/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.CollectorContext;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorState;
import shadow.com.networknt.schema.ValidatorTypeCode;
import shadow.com.networknt.schema.walk.DefaultPropertyWalkListenerRunner;
import shadow.com.networknt.schema.walk.WalkListenerRunner;

public class PropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private Map<String, JsonSchema> schemas;
    private WalkListenerRunner propertyWalkListenerRunner;
    private ValidationContext validationContext;

    public PropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES, validationContext);
        this.validationContext = validationContext;
        this.schemas = new HashMap<String, JsonSchema>();
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            this.schemas.put(pname, new JsonSchema(validationContext, schemaPath + "/" + pname, parentSchema.getCurrentUri(), schemaNode.get(pname), parentSchema));
        }
        this.propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.config.getPropertyWalkListeners());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("shadow.com.networknt.schema.ValidatorState");
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            Set<ValidationMessage> requiredErrors;
            JsonSchema propertySchema = entry.getValue();
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                boolean isComplex = state.isComplexValidator();
                if (state.isComplexValidator()) {
                    state.setMatchedNode(true);
                }
                state.setComplexValidator(false);
                if (!state.isWalkEnabled()) {
                    errors.addAll(propertySchema.validate(propertyNode, rootNode, at + "." + entry.getKey()));
                } else {
                    this.walkSchema(entry, node, rootNode, at, state.isValidationEnabled(), errors);
                }
                state.setComplexValidator(isComplex);
                if (!state.isComplexValidator()) continue;
                state.setMatchedNode(true);
                continue;
            }
            if (!this.getParentSchema().hasRequiredValidator() || (requiredErrors = this.getParentSchema().getRequiredValidator().validate(node, rootNode, at)).isEmpty()) continue;
            if (state.isComplexValidator()) {
                state.setMatchedNode(false);
                return Collections.unmodifiableSet(new LinkedHashSet());
            }
            errors.addAll(requiredErrors);
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(node, rootNode, at));
        } else {
            for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
                this.walkSchema(entry, node, rootNode, at, shouldValidateSchema, validationMessages);
            }
        }
        return validationMessages;
    }

    private void walkSchema(Map.Entry<String, JsonSchema> entry, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages) {
        JsonSchema propertySchema = entry.getValue();
        JsonNode propertyNode = node == null ? null : node.get(entry.getKey());
        boolean executeWalk = this.propertyWalkListenerRunner.runPreWalkListeners(ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, at + "." + entry.getKey(), propertySchema.getSchemaPath(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext.getJsonSchemaFactory());
        if (executeWalk) {
            validationMessages.addAll(propertySchema.walk(propertyNode, rootNode, at + "." + entry.getKey(), shouldValidateSchema));
        }
        this.propertyWalkListenerRunner.runPostWalkListeners(ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, at + "." + entry.getKey(), propertySchema.getSchemaPath(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext.getJsonSchemaFactory(), validationMessages);
    }

    public Map<String, JsonSchema> getSchemas() {
        return this.schemas;
    }
}

