/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.RequiredValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class NotValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private JsonSchema schema;

    public NotValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.NOT, validationContext);
        this.schema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema);
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        Set<ValidationMessage> errors = this.schema.validate(node, rootNode, at);
        if (errors.isEmpty()) {
            return Collections.singleton(this.buildValidationMessage(at, this.schema.toString()));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        return this.schema.walk(node, rootNode, at, shouldValidateSchema);
    }
}

