/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.Format;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonType;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.TypeFactory;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class FormatValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.FORMAT, validationContext);
        this.format = format;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.config);
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (this.format != null) {
            try {
                if (!this.format.matches(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on " + at + ": Invalid RE syntax [" + this.format.getName() + "]", pse);
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

