/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.DateTimeValidator;
import shadow.com.networknt.schema.Format;
import shadow.com.networknt.schema.FormatValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.Keyword;
import shadow.com.networknt.schema.UUIDValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidatorTypeCode;
import shadow.com.networknt.schema.format.EmailValidator;

public class FormatKeyword
implements Keyword {
    private final ValidatorTypeCode type;
    private final Map<String, Format> formats;
    private final String DATE = "date";
    private final String DATE_TIME = "date-time";
    private final String UUID = "uuid";
    private final String EMAIL = "email";

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this.type = type;
        this.formats = formats;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws Exception {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
            if (format != null) {
                return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format);
            }
            if (formatName.equals("date") || formatName.equals("date-time")) {
                return new DateTimeValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
            if (formatName.equals("uuid")) {
                return new UUIDValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
            if (formatName.equals("email")) {
                return new EmailValidator(schemaPath, schemaNode, parentSchema, validationContext, formatName);
            }
        }
        return new FormatValidator(schemaPath, schemaNode, parentSchema, validationContext, format);
    }

    @Override
    public String getValue() {
        return this.type.getValue();
    }
}

