/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.node.DecimalNode;
import shadow.com.fasterxml.jackson.databind.node.NullNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonType;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.TypeFactory;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class EnumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(EnumValidator.class);
    private final Set<JsonNode> nodes;
    private final String error;

    public EnumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ENUM, validationContext);
        if (schemaNode != null && schemaNode.isArray()) {
            JsonNode nullable;
            this.nodes = new HashSet<JsonNode>();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String separator = "";
            for (JsonNode n : schemaNode) {
                if (n.isNumber()) {
                    this.nodes.add(DecimalNode.valueOf(n.decimalValue()));
                } else {
                    this.nodes.add(n);
                }
                sb.append(separator);
                sb.append(n.asText());
                separator = ", ";
            }
            if (this.config.isHandleNullableField() && (nullable = parentSchema.getSchemaNode().get("nullable")) != null && nullable.asBoolean()) {
                this.nodes.add(NullNode.getInstance());
                separator = ", ";
                sb.append(separator);
                sb.append("null");
            }
            sb.append(']');
            this.error = sb.toString();
        } else {
            this.nodes = Collections.emptySet();
            this.error = "[none]";
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (node.isNumber()) {
            node = DecimalNode.valueOf(node.decimalValue());
        }
        if (!(this.nodes.contains(node) || this.config.isTypeLoose() && this.isTypeLooseContainsInEnum(node))) {
            errors.add(this.buildValidationMessage(at, this.error));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isTypeLooseContainsInEnum(JsonNode node) {
        if (TypeFactory.getValueNodeType(node, this.config) == JsonType.STRING) {
            String nodeText = node.textValue();
            for (JsonNode n : this.nodes) {
                String value = n.asText();
                if (value == null || !value.equals(nodeText)) continue;
                return true;
            }
        }
        return false;
    }
}

