/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonType;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.RequiredValidator;
import shadow.com.networknt.schema.TypeValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class AnyOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private static final String REMARK = "Remaining validation messages report why candidate schemas didn't match";
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private final ValidationContext validationContext;
    private final ValidationContext.DiscriminatorContext discriminatorContext;

    public AnyOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema));
        }
        this.discriminatorContext = this.config.isOpenAPI3StyleDiscriminators() ? new ValidationContext.DiscriminatorContext() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.config.isOpenAPI3StyleDiscriminators()) {
            this.validationContext.enterDiscriminatorContext(this.discriminatorContext, at);
        }
        LinkedHashSet<ValidationMessage> allErrors = new LinkedHashSet<ValidationMessage>();
        String typeValidatorName = "anyOf/type";
        try {
            for (JsonSchema schema : this.schemas) {
                TypeValidator typeValidator;
                if (schema.getValidators().containsKey(typeValidatorName) && (typeValidator = (TypeValidator)schema.getValidators().get(typeValidatorName)).getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                    allErrors.add(this.buildValidationMessage(at, typeValidator.getSchemaType().toString()));
                    continue;
                }
                Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
                if (errors.isEmpty() && !this.config.isOpenAPI3StyleDiscriminators()) {
                    Set<ValidationMessage> set = errors;
                    return set;
                }
                if (this.config.isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isDiscriminatorMatchFound()) {
                    if (!errors.isEmpty()) {
                        errors.add(this.buildValidationMessage(at, DISCRIMINATOR_REMARK));
                    }
                    Set<ValidationMessage> set = errors;
                    return set;
                }
                allErrors.addAll(errors);
            }
            if (this.config.isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isActive()) {
                HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
                errors.add(this.buildValidationMessage(at, "based on the provided discriminator. No alternative could be chosen based on the discriminator property"));
                Set<ValidationMessage> set = Collections.unmodifiableSet(errors);
                return set;
            }
        }
        finally {
            if (this.config.isOpenAPI3StyleDiscriminators()) {
                this.validationContext.leaveDiscriminatorContextImmediately(at);
            }
        }
        return Collections.unmodifiableSet(allErrors);
    }
}

