/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.node.ObjectNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class AllOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final ValidationContext validationContext;
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            errors.addAll(schema.validate(node, rootNode, at));
            if (!this.config.isOpenAPI3StyleDiscriminators()) continue;
            Iterator<JsonNode> arrayElements = this.schemaNode.elements();
            while (arrayElements.hasNext()) {
                ObjectNode discriminator;
                ValidationContext.DiscriminatorContext currentDiscriminatorContext;
                ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                JsonNode $ref = allOfEntry.get("$ref");
                if (null == $ref || null == (currentDiscriminatorContext = this.validationContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, at);
                String discriminatorPropertyName = discriminator.get("propertyName").asText();
                String discriminatorPropertyValue = node.get(discriminatorPropertyName).textValue();
                JsonSchema jsonSchema = this.parentSchema;
                AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            validationMessages.addAll(schema.walk(node, rootNode, at, shouldValidateSchema));
        }
        return Collections.unmodifiableSet(validationMessages);
    }
}

