/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.ErrorMessageType;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.ValidationMessage;

public abstract class AbstractJsonValidator
implements JsonValidator {
    private final String keyword;

    protected AbstractJsonValidator(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at, String ... arguments) {
        return ValidationMessage.of(this.keyword, errorMessageType, at, arguments);
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at, Map<String, Object> details) {
        return ValidationMessage.of(this.keyword, errorMessageType, at, details);
    }

    protected Set<ValidationMessage> pass() {
        return Collections.emptySet();
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at, Map<String, Object> details) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at, details));
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at, String ... arguments) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at, arguments));
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        Set<ValidationMessage> validationMessages = Collections.emptySet();
        if (shouldValidateSchema) {
            validationMessages = this.validate(node, rootNode, at);
        }
        return validationMessages;
    }
}

