/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.google.common.collect;

import java.util.Map;
import shadow.com.google.common.annotations.Beta;
import shadow.com.google.common.annotations.GwtCompatible;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.collect.ElementTypesAreNonnullByDefault;
import shadow.com.google.common.collect.ForwardingObject;
import shadow.com.google.common.collect.ParametricNullness;
import shadow.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMapEntry<K, V>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    @Override
    protected abstract Map.Entry<K, V> delegate();

    @Override
    @ParametricNullness
    public K getKey() {
        return this.delegate().getKey();
    }

    @Override
    @ParametricNullness
    public V getValue() {
        return this.delegate().getValue();
    }

    @Override
    @ParametricNullness
    public V setValue(@ParametricNullness V value) {
        return this.delegate().setValue(value);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardEquals(@CheckForNull Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    protected int standardHashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    @Beta
    protected String standardToString() {
        String string = String.valueOf(this.getKey());
        String string2 = String.valueOf(this.getValue());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString();
    }
}

