/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.module.afterburner.deser;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import shadow.com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import shadow.com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableObjectMethodProperty
extends OptimizedSettableBeanProperty<SettableObjectMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableObjectMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableObjectMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableObjectMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            this._propertyMutator.objectSetter(bean, this._optimizedIndex, value);
        }
        catch (Throwable e) {
            this._reportProblem(bean, value, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        return this.setAndReturn(instance, value);
    }

    @Override
    public void set(Object bean, Object v) throws IOException {
        try {
            this._propertyMutator.objectSetter(bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }
}

