/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import shadow.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import shadow.org.joda.time.DateTimeZone;
import shadow.org.joda.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalDateTimeDeserializer(format);
    }

    @Override
    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                String str = p.getText().trim();
                return str.length() == 0 ? null : this._format.createParser(ctxt).parseLocalDateTime(str);
            }
            case 7: {
                DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
                return new LocalDateTime(p.getLongValue(), tz);
            }
            case 3: {
                JsonToken t = p.nextToken();
                LocalDateTime dt = null;
                if (t.isNumeric()) {
                    int year = p.getIntValue();
                    t = p.nextToken();
                    if (t.isNumeric()) {
                        int month = p.getIntValue();
                        t = p.nextToken();
                        if (t.isNumeric()) {
                            int day = p.getIntValue();
                            t = p.nextToken();
                            if (t.isNumeric()) {
                                int hour = p.getIntValue();
                                t = p.nextToken();
                                if (t.isNumeric()) {
                                    int minute = p.getIntValue();
                                    t = p.nextToken();
                                    if (t.isNumeric()) {
                                        int second = p.getIntValue();
                                        t = p.nextToken();
                                        int millisecond = 0;
                                        if (t.isNumeric()) {
                                            millisecond = p.getIntValue();
                                            t = p.nextToken();
                                        }
                                        dt = new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                                    }
                                }
                            }
                        }
                    }
                }
                if (t == JsonToken.END_ARRAY) {
                    return dt;
                }
                throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after LocalDateTime ints");
            }
        }
        return (LocalDateTime)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected String, Number or JSON Array", new Object[0]);
    }
}

