/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import shadow.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import shadow.org.joda.time.DateTimeZone;
import shadow.org.joda.time.LocalDate;

public class LocalDateDeserializer
extends JodaDateDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT);
    }

    public LocalDateDeserializer(JacksonJodaDateFormat format) {
        super(LocalDate.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalDateDeserializer(format);
    }

    @Override
    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                String str = p.getText().trim();
                return str.length() == 0 ? null : this._format.createParser(ctxt).parseLocalDate(str);
            }
            case 7: {
                DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
                return new LocalDate(p.getLongValue(), tz);
            }
            case 3: {
                int day;
                int month;
                int year = p.nextIntValue(-1);
                if (year == -1) {
                    year = this._parseIntPrimitive(p, ctxt);
                }
                if ((month = p.nextIntValue(-1)) == -1) {
                    month = this._parseIntPrimitive(p, ctxt);
                }
                if ((day = p.nextIntValue(-1)) == -1) {
                    day = this._parseIntPrimitive(p, ctxt);
                }
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "after LocalDate ints");
                }
                return new LocalDate(year, month, day);
            }
        }
        return (LocalDate)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected String, Number or JSON Array", new Object[0]);
    }
}

