/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import shadow.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import shadow.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import shadow.org.joda.time.DateTime;
import shadow.org.joda.time.DateTimeZone;
import shadow.org.joda.time.ReadableInstant;

public class DateTimeDeserializer
extends JodaDateDeserializerBase<ReadableInstant> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializer(Class<?> cls, JacksonJodaDateFormat format) {
        super(cls, format);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer(cls, FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new DateTimeDeserializer(this._valueClass, format);
    }

    @Override
    public ReadableInstant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
            return new DateTime(p.getLongValue(), tz);
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            int ix = str.indexOf(91);
            if (ix > 0) {
                DateTimeZone tz;
                int ix2 = str.lastIndexOf(93);
                String tzId = ix2 < ix ? str.substring(ix + 1) : str.substring(ix + 1, ix2);
                try {
                    tz = DateTimeZone.forID(tzId);
                }
                catch (IllegalArgumentException e) {
                    ctxt.reportInputMismatch(this.handledType(), "Unknown DateTimeZone id '%s'", tzId);
                    tz = null;
                }
                str = str.substring(0, ix);
                DateTime result = this._format.createParser(ctxt).withZone(tz).parseDateTime(str);
                if (this._format.shouldAdjustToContextTimeZone(ctxt)) {
                    result = result.withZone(this._format.getTimeZone());
                }
                return result;
            }
            return this._format.createParser(ctxt).parseDateTime(str);
        }
        return (ReadableInstant)this._handleNotNumberOrString(p, ctxt);
    }
}

