/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalLong;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import shadow.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

final class OptionalLongSerializer
extends StdScalarSerializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsLong());
        } else {
            jgen.writeNull();
        }
    }
}

