/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.stream.LongStream;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import shadow.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;

public class LongStreamSerializer
extends StdSerializer<LongStream> {
    private static final long serialVersionUID = 1L;
    public static final LongStreamSerializer INSTANCE = new LongStreamSerializer();

    private LongStreamSerializer() {
        super(LongStream.class);
    }

    @Override
    public void serialize(LongStream stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (LongStream ls = stream;){
            jgen.writeStartArray();
            ls.forEachOrdered(value -> {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

