/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import shadow.com.fasterxml.jackson.core.JsonGenerationException;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.core.type.WritableTypeId;
import shadow.com.fasterxml.jackson.databind.BeanProperty;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import shadow.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shadow.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import shadow.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import shadow.com.fasterxml.jackson.datatype.guava.deser.util.RangeHelper;
import shadow.com.google.common.collect.BoundType;
import shadow.com.google.common.collect.Range;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;
    protected final RangeHelper.RangeProperties _fieldNames;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    @Deprecated
    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        this(type, endpointSer, RangeHelper.standardNames());
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer, RangeHelper.RangeProperties fieldNames) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
        this._fieldNames = fieldNames;
    }

    @Override
    @Deprecated
    public boolean isEmpty(Range<?> value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Range<?> value) {
        return value.isEmpty();
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        PropertyNamingStrategy propertyNamingStrategy = prov.getConfig().getPropertyNamingStrategy();
        RangeHelper.RangeProperties nameMapping = RangeHelper.getPropertyNames(prov.getConfig(), propertyNamingStrategy);
        JsonSerializer<Object> endpointSer = this._endpointSerializer;
        if (endpointSer == null) {
            JavaType endpointType = this._rangeType.containedTypeOrUnknown(0);
            if (endpointType != null && !endpointType.hasRawClass(Object.class)) {
                JsonSerializer<Object> ser = prov.findValueSerializer(endpointType, property);
                return new RangeSerializer(this._rangeType, ser, nameMapping);
            }
        } else if (endpointSer instanceof ContextualSerializer) {
            endpointSer = ((ContextualSerializer)((Object)endpointSer)).createContextual(prov, property);
        }
        if (endpointSer != this._endpointSerializer || nameMapping != null) {
            return new RangeSerializer(this._rangeType, endpointSer, nameMapping);
        }
        return this;
    }

    @Override
    public void serialize(Range<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        gen.writeStartObject(value);
        this._writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Range<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        this._writeContents(value, gen, provider);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    private void _writeContents(Range<?> value, JsonGenerator g, SerializerProvider provider) throws IOException {
        String fieldName;
        if (value.hasLowerBound()) {
            fieldName = this._fieldNames.lowerEndpoint;
            if (this._endpointSerializer != null) {
                g.writeFieldName(fieldName);
                this._endpointSerializer.serialize(value.lowerEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField(fieldName, value.lowerEndpoint(), g);
            }
            g.writeStringField(this._fieldNames.lowerBoundType, value.lowerBoundType().name());
        }
        if (value.hasUpperBound()) {
            fieldName = this._fieldNames.upperEndpoint;
            if (this._endpointSerializer != null) {
                g.writeFieldName(fieldName);
                this._endpointSerializer.serialize(value.upperEndpoint(), g, provider);
            } else {
                provider.defaultSerializeField(fieldName, value.upperEndpoint(), g);
            }
            g.writeStringField(this._fieldNames.upperBoundType, value.upperBoundType().name());
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor;
        if (visitor != null && (objectVisitor = visitor.expectObjectFormat(typeHint)) != null && this._endpointSerializer != null) {
            JavaType endpointType = this._rangeType.containedType(0);
            JavaType btType = visitor.getProvider().constructType((Type)((Object)BoundType.class));
            JsonSerializer<Object> btSer = visitor.getProvider().findValueSerializer(btType, null);
            objectVisitor.property(this._fieldNames.lowerEndpoint, this._endpointSerializer, endpointType);
            objectVisitor.property(this._fieldNames.lowerBoundType, btSer, btType);
            objectVisitor.property(this._fieldNames.upperEndpoint, this._endpointSerializer, endpointType);
            objectVisitor.property(this._fieldNames.upperBoundType, btSer, btType);
        }
    }
}

