/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.List;
import shadow.com.fasterxml.jackson.core.JsonParseException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.BeanProperty;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import shadow.com.google.common.collect.ImmutableRangeSet;
import shadow.com.google.common.collect.Range;
import shadow.com.google.common.collect.RangeSet;

public class RangeSetDeserializer
extends JsonDeserializer<RangeSet<Comparable<?>>>
implements ContextualDeserializer {
    private JavaType genericRangeListType;

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.genericRangeListType == null) {
            throw new JsonParseException(p, "RangeSetJsonSerializer was not contextualized (no deserialize target type). You need to specify the generic type down to the generic parameter of RangeSet.");
        }
        Iterable ranges = (Iterable)ctxt.findContextualValueDeserializer(this.genericRangeListType, null).deserialize(p, ctxt);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType genericType = ctxt.getContextualType().containedType(0);
        if (genericType == null) {
            return this;
        }
        RangeSetDeserializer deserializer = new RangeSetDeserializer();
        deserializer.genericRangeListType = ctxt.getTypeFactory().constructCollectionType(List.class, ctxt.getTypeFactory().constructParametricType(Range.class, genericType));
        return deserializer;
    }
}

