/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.databind.jsontype.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import shadow.com.fasterxml.jackson.databind.BeanDescription;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;

public class SubTypeValidator {
    protected static final String PREFIX_SPRING = "shadow.org.springframework.";
    protected static final String PREFIX_C3P0 = "shadow.com.mchange.v2.c3p0.";
    protected static final Set<String> DEFAULT_NO_DESER_CLASS_NAMES;
    protected Set<String> _cfgIllegalClassNames = DEFAULT_NO_DESER_CLASS_NAMES;
    private static final SubTypeValidator instance;

    protected SubTypeValidator() {
    }

    public static SubTypeValidator instance() {
        return instance;
    }

    public void validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        String full;
        block6: {
            block7: {
                block8: {
                    Class<?> raw = type.getRawClass();
                    full = raw.getName();
                    if (this._cfgIllegalClassNames.contains(full)) break block6;
                    if (raw.isInterface()) break block7;
                    if (!full.startsWith(PREFIX_SPRING)) break block8;
                    for (Class<?> cls = raw; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                        String name = cls.getSimpleName();
                        if (!"AbstractPointcutAdvisor".equals(name) && !"AbstractApplicationContext".equals(name)) {
                            continue;
                        }
                        break block6;
                    }
                    break block7;
                }
                if (full.startsWith(PREFIX_C3P0) && full.endsWith("DataSource")) break block6;
            }
            return;
        }
        ctxt.reportBadTypeDefinition(beanDesc, "Illegal type (%s) to deserialize: prevented for security reasons", full);
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("shadow.org.apache.commons.collections.functors.InvokerTransformer");
        s.add("shadow.org.apache.commons.collections.functors.InstantiateTransformer");
        s.add("shadow.org.apache.commons.collections4.functors.InvokerTransformer");
        s.add("shadow.org.apache.commons.collections4.functors.InstantiateTransformer");
        s.add("shadow.org.codehaus.groovy.runtime.ConvertedClosure");
        s.add("shadow.org.codehaus.groovy.runtime.MethodClosure");
        s.add("shadow.org.springframework.beans.factory.ObjectFactory");
        s.add("shadow.com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
        s.add("shadow.org.apache.xalan.xsltc.trax.TemplatesImpl");
        s.add("shadow.com.sun.rowset.JdbcRowSetImpl");
        s.add("java.util.logging.FileHandler");
        s.add("java.rmi.server.UnicastRemoteObject");
        s.add("shadow.org.springframework.beans.factory.config.PropertyPathFactoryBean");
        s.add("shadow.org.springframework.aop.config.MethodLocatingFactoryBean");
        s.add("shadow.org.springframework.beans.factory.config.BeanReferenceFactoryBean");
        s.add("shadow.org.apache.tomcat.dbcp.dbcp2.BasicDataSource");
        s.add("shadow.com.sun.org.apache.bcel.internal.util.ClassLoader");
        s.add("shadow.org.hibernate.jmx.StatisticsService");
        s.add("shadow.org.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
        s.add("shadow.org.apache.ibatis.parsing.XPathParser");
        s.add("jodd.db.connection.DataSourceConnectionProvider");
        s.add("oracle.jdbc.connector.OracleManagedConnectionFactory");
        s.add("oracle.jdbc.rowset.OracleJDBCRowSet");
        s.add("shadow.org.slf4j.ext.EventData");
        s.add("flex.messaging.util.concurrent.AsynchBeansWorkManagerExecutor");
        s.add("shadow.com.sun.deploy.security.ruleset.DRSHelper");
        s.add("shadow.org.apache.axis2.jaxws.spi.handler.HandlerResolverImpl");
        s.add("shadow.org.jboss.util.propertyeditor.DocumentEditor");
        s.add("shadow.org.apache.openjpa.ee.RegistryManagedRuntime");
        s.add("shadow.org.apache.openjpa.ee.JNDIManagedRuntime");
        s.add("shadow.org.apache.openjpa.ee.WASRegistryManagedRuntime");
        s.add("shadow.org.apache.axis2.transport.jms.JMSOutTransportInfo");
        s.add("shadow.com.mysql.cj.jdbc.admin.MiniAdmin");
        s.add("ch.qos.logback.core.db.DriverManagerConnectionSource");
        s.add("shadow.org.jdom.transform.XSLTransformer");
        s.add("shadow.org.jdom2.transform.XSLTransformer");
        s.add("net.sf.ehcache.transaction.manager.DefaultTransactionManagerLookup");
        s.add("net.sf.ehcache.hibernate.EhcacheJtaTransactionManagerLookup");
        s.add("ch.qos.logback.core.db.JNDIConnectionSource");
        s.add("shadow.com.zaxxer.hikari.HikariConfig");
        s.add("shadow.com.zaxxer.hikari.HikariDataSource");
        s.add("shadow.org.apache.cxf.jaxrs.provider.XSLTJaxbProvider");
        s.add("shadow.org.apache.commons.configuration.JNDIConfiguration");
        s.add("shadow.org.apache.commons.configuration2.JNDIConfiguration");
        s.add("shadow.org.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("shadow.com.sun.org.apache.xalan.internal.lib.sql.JNDIConnectionPool");
        s.add("shadow.org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
        s.add("shadow.org.apache.commons.dbcp.datasources.SharedPoolDataSource");
        s.add("shadow.com.p6spy.engine.spy.P6DataSource");
        s.add("shadow.org.apache.log4j.receivers.db.DriverManagerConnectionSource");
        s.add("shadow.org.apache.log4j.receivers.db.JNDIConnectionSource");
        s.add("net.sf.ehcache.transaction.manager.selector.GenericJndiSelector");
        s.add("net.sf.ehcache.transaction.manager.selector.GlassfishSelector");
        s.add("shadow.org.apache.xbean.propertyeditor.JndiConverter");
        s.add("shadow.org.apache.hadoop.shaded.com.zaxxer.hikari.HikariConfig");
        s.add("shadow.com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig");
        s.add("br.com.anteros.dbcp.AnterosDBCPConfig");
        s.add("br.com.anteros.dbcp.AnterosDBCPDataSource");
        s.add("shadow.javax.swing.JEditorPane");
        s.add("shadow.javax.swing.JTextPane");
        s.add("shadow.org.apache.shiro.realm.jndi.JndiRealmFactory");
        s.add("shadow.org.apache.shiro.jndi.JndiObjectFactory");
        s.add("shadow.org.apache.ignite.cache.jta.jndi.CacheJndiTmLookup");
        s.add("shadow.org.apache.ignite.cache.jta.jndi.CacheJndiTmFactory");
        s.add("shadow.org.quartz.utils.JNDIConnectionProvider");
        s.add("shadow.org.apache.aries.transaction.jms.internal.XaPooledConnectionFactory");
        s.add("shadow.org.apache.aries.transaction.jms.RecoverablePooledConnectionFactory");
        s.add("shadow.com.caucho.config.types.ResourceRef");
        s.add("shadow.org.aoju.bus.proxy.provider.RmiProvider");
        s.add("shadow.org.aoju.bus.proxy.provider.remoting.RmiProvider");
        s.add("shadow.org.apache.activemq.ActiveMQConnectionFactory");
        s.add("shadow.org.apache.activemq.ActiveMQXAConnectionFactory");
        s.add("shadow.org.apache.activemq.spring.ActiveMQConnectionFactory");
        s.add("shadow.org.apache.activemq.spring.ActiveMQXAConnectionFactory");
        s.add("shadow.org.apache.activemq.pool.JcaPooledConnectionFactory");
        s.add("shadow.org.apache.activemq.pool.PooledConnectionFactory");
        s.add("shadow.org.apache.activemq.pool.XaPooledConnectionFactory");
        s.add("shadow.org.apache.activemq.jms.pool.XaPooledConnectionFactory");
        s.add("shadow.org.apache.activemq.jms.pool.JcaPooledConnectionFactory");
        s.add("shadow.org.apache.commons.proxy.provider.remoting.RmiProvider");
        s.add("shadow.org.apache.commons.jelly.impl.Embedded");
        s.add("oadd.org.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("oracle.jms.AQjmsQueueConnectionFactory");
        s.add("oracle.jms.AQjmsXATopicConnectionFactory");
        s.add("oracle.jms.AQjmsTopicConnectionFactory");
        s.add("oracle.jms.AQjmsXAQueueConnectionFactory");
        s.add("oracle.jms.AQjmsXAConnectionFactory");
        s.add("shadow.org.jsecurity.realm.jndi.JndiRealmFactory");
        s.add("shadow.com.pastdev.httpcomponents.configuration.JndiConfiguration");
        s.add("shadow.com.nqadmin.rowset.JdbcRowSetImpl");
        s.add("shadow.org.arrah.framework.rdbms.UpdatableJdbcRowsetImpl");
        DEFAULT_NO_DESER_CLASS_NAMES = Collections.unmodifiableSet(s);
        instance = new SubTypeValidator();
    }
}

