/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schema.ConstraintType;
import us.fatehi.utility.string.StringFormat;

public enum TableConstraintType implements ConstraintType
{
    unknown("unknown"),
    primary_key("PRIMARY KEY"),
    foreign_key("FOREIGN KEY"),
    unique("UNIQUE"),
    check("CHECK");

    private static final SchemaCrawlerLogger LOGGER;
    private final String value;

    public static TableConstraintType valueOfFromValue(String value) {
        for (TableConstraintType type : TableConstraintType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        LOGGER.log(Level.FINE, new StringFormat("Unknown value <%s>", value));
        return unknown;
    }

    private TableConstraintType(String value) {
        this.value = value;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    static {
        LOGGER = SchemaCrawlerLogger.getLogger(TableConstraintType.class.getName());
    }
}

