/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.analysis.counts.TableRowCountsFilter;
import schemacrawler.analysis.counts.TableRowCountsRetriever;
import schemacrawler.crawl.DataTypeRetriever;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.FunctionParameterRetriever;
import schemacrawler.crawl.IndexRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.PrimaryKeyRetriever;
import schemacrawler.crawl.ProcedureParameterRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineExtRetriever;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.SequenceRetriever;
import schemacrawler.crawl.SynonymRetriever;
import schemacrawler.crawl.TableColumnRetriever;
import schemacrawler.crawl.TableConstraintRetriever;
import schemacrawler.crawl.TableExtRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.crawl.WeakAssociationsRetriever;
import schemacrawler.filter.ReducerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import us.fatehi.utility.StopWatch;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawler {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawler.class.getName());
    private final Connection connection;
    private final SchemaCrawlerOptions options;
    private final SchemaRetrievalOptions schemaRetrievalOptions;
    private MutableCatalog catalog;
    private RetrieverConnection retrieverConnection;

    public SchemaCrawler(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions options) {
        this.connection = Objects.requireNonNull(connection, "No connection specified");
        this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database-specific schema retrieval overrides provided");
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
    }

    public Catalog crawl() throws SchemaCrawlerException {
        this.catalog = new MutableCatalog("catalog");
        try {
            this.retrieverConnection = new RetrieverConnection(this.connection, this.schemaRetrievalOptions);
            this.crawlDatabaseInfo();
            LOGGER.log(Level.INFO, String.format("%n%s", this.catalog.getCrawlInfo()));
            this.crawlSchemas();
            this.crawlColumnDataTypes();
            this.crawlTables();
            this.crawlRoutines();
            this.crawlSynonyms();
            this.crawlSequences();
            this.crawlAnalysis();
            return this.catalog;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Database access exception", e);
        }
    }

    private void crawlAnalysis() throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
        StopWatch stopWatch = new StopWatch("crawlAnalysis");
        LOGGER.log(Level.INFO, "Crawling schema analysis");
        try {
            WeakAssociationsRetriever weakAssociationsRetriever = new WeakAssociationsRetriever(this.catalog);
            stopWatch.time("retrieveWeakAssociations", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveWeakAssociations)) {
                    weakAssociationsRetriever.retrieveWeakAssociations();
                    return null;
                }
                LOGGER.log(Level.INFO, "Not retrieving weak associations, since this was not requested");
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving weak association information", e);
        }
        LOGGER.log(Level.INFO, "Crawling table row counts");
        try {
            TableRowCountsRetriever rowCountsRetriever = new TableRowCountsRetriever(this.retrieverConnection.getConnection(), this.catalog);
            stopWatch.time("retrieveTableRowCounts", () -> {
                boolean loadRowCounts = this.options.getLoadOptions().isLoadRowCounts();
                if (loadRowCounts) {
                    rowCountsRetriever.retrieveTableRowCounts();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving table row counts, since this was not requested");
                }
                return null;
            });
            stopWatch.time("filterEmptyTables", () -> {
                this.catalog.reduce(Table.class, ReducerFactory.getTableReducer(new TableRowCountsFilter(this.options.getFilterOptions())));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving table row counts", e);
        }
    }

    private void crawlColumnDataTypes() throws SchemaCrawlerException {
        try {
            LOGGER.log(Level.INFO, "Crawling column data types");
            StopWatch stopWatch = new StopWatch("crawlColumnDataTypes");
            SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(this.retrieverConnection, this.catalog, this.options);
            DataTypeRetriever dataTypeRetriever = new DataTypeRetriever(this.retrieverConnection, this.catalog, this.options);
            stopWatch.time("retrieveSystemColumnDataTypes", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveColumnDataTypes)) {
                    LOGGER.log(Level.INFO, "Retrieving system column data types");
                    dataTypeRetriever.retrieveSystemColumnDataTypes();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving system column data types, since this was not requested");
                }
                return null;
            });
            stopWatch.time("retrieveUserDefinedColumnDataTypes", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes)) {
                    LOGGER.log(Level.INFO, "Retrieving user column data types");
                    for (Schema schema : retriever.getAllSchemas()) {
                        dataTypeRetriever.retrieveUserDefinedColumnDataTypes(schema);
                    }
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving user column data types, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving column data type information", e);
        }
    }

    private void crawlDatabaseInfo() throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
            if (!infoLevel.is(SchemaInfoRetrieval.retrieveDatabaseInfo)) {
                LOGGER.log(Level.INFO, "Not retrieving database information, since this was not requested");
                return;
            }
            StopWatch stopWatch = new StopWatch("crawlDatabaseInfo");
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(this.retrieverConnection, this.catalog, this.options);
            LOGGER.log(Level.INFO, "Retrieving database information");
            stopWatch.time("retrieveDatabaseInfo", () -> {
                retriever.retrieveDatabaseInfo();
                return null;
            });
            stopWatch.time("retrieveAdditionalDatabaseInfo", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo)) {
                    retriever.retrieveAdditionalDatabaseInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving additional database information, since this was not requested");
                }
                return null;
            });
            stopWatch.time("retrieveServerInfo", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveServerInfo)) {
                    retriever.retrieveServerInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
                }
                return null;
            });
            stopWatch.time("retrieveDatabaseUsers", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveDatabaseUsers)) {
                    retriever.retrieveDatabaseUsers();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving database users, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving JDBC driver information");
            stopWatch.time("retrieveJdbcDriverInfo", () -> {
                retriever.retrieveJdbcDriverInfo();
                return null;
            });
            stopWatch.time("retrieveAdditionalJdbcDriverInfo", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo)) {
                    retriever.retrieveAdditionalJdbcDriverInfo();
                } else {
                    LOGGER.log(Level.INFO, "Not retrieving additional JDBC driver information, since this was not requested");
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving SchemaCrawler crawl information");
            stopWatch.time("retrieveCrawlInfo", () -> {
                retriever.retrieveCrawlInfo();
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private void crawlRoutines() throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!infoLevel.is(SchemaInfoRetrieval.retrieveRoutines) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving routines, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlRoutines");
        LOGGER.log(Level.INFO, "Crawling routines");
        try {
            RoutineRetriever retriever = new RoutineRetriever(this.retrieverConnection, this.catalog, this.options);
            RoutineExtRetriever retrieverExtra = new RoutineExtRetriever(this.retrieverConnection, this.catalog, this.options);
            ProcedureParameterRetriever procedureParameterRetriever = new ProcedureParameterRetriever(this.retrieverConnection, this.catalog, this.options);
            FunctionParameterRetriever functionParameterRetriever = new FunctionParameterRetriever(this.retrieverConnection, this.catalog, this.options);
            Collection<RoutineType> routineTypes = limitOptions.getRoutineTypes();
            stopWatch.time("retrieveRoutines", () -> {
                NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
                if (routineTypes.contains((Object)RoutineType.procedure)) {
                    LOGGER.log(Level.INFO, "Retrieving procedure names");
                    retriever.retrieveProcedures(schemas, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion));
                }
                if (routineTypes.contains((Object)RoutineType.function)) {
                    LOGGER.log(Level.INFO, "Retrieving function names");
                    retriever.retrieveFunctions(schemas, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion));
                }
                return null;
            });
            NamedObjectList<MutableRoutine> allRoutines = this.catalog.getAllRoutines();
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d routines", allRoutines.size()));
            if (allRoutines.isEmpty()) {
                return;
            }
            stopWatch.time("retrieveRoutineParameters", () -> {
                LOGGER.log(Level.INFO, "Retrieving routine columns");
                if (infoLevel.is(SchemaInfoRetrieval.retrieveRoutineParameters) && !limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion)) {
                    if (routineTypes.contains((Object)RoutineType.procedure)) {
                        procedureParameterRetriever.retrieveProcedureParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                    }
                    if (routineTypes.contains((Object)RoutineType.function)) {
                        functionParameterRetriever.retrieveFunctionParameters(allRoutines, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion));
                    }
                }
                return null;
            });
            stopWatch.time("filterAndSortRoutines", () -> {
                this.catalog.reduce(Routine.class, ReducerFactory.getRoutineReducer(this.options));
                return null;
            });
            stopWatch.time("retrieveRoutineInformation", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveRoutineInformation)) {
                    retrieverExtra.retrieveRoutineInformation();
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving routine information", e);
        }
    }

    private void crawlSchemas() throws SchemaCrawlerException {
        StopWatch stopWatch = new StopWatch("crawlSchemas");
        LOGGER.log(Level.INFO, "Crawling schemas");
        try {
            SchemaRetriever retriever = new SchemaRetriever(this.retrieverConnection, this.catalog, this.options);
            stopWatch.time("retrieveSchemas", () -> {
                retriever.retrieveSchemas(this.options.getLimitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion));
                return null;
            });
            stopWatch.time("filterAndSortSchemas", () -> {
                this.catalog.reduce(Schema.class, ReducerFactory.getSchemaReducer(this.options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
            NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
            if (schemas.isEmpty()) {
                throw new SchemaCrawlerException("No matching schemas found");
            }
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d schemas", schemas.size()));
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving schema information", e);
        }
    }

    private void crawlSequences() throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!infoLevel.is(SchemaInfoRetrieval.retrieveSequenceInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlSequences");
        LOGGER.log(Level.INFO, "Crawling sequences");
        try {
            SequenceRetriever retrieverExtra = new SequenceRetriever(this.retrieverConnection, this.catalog, this.options);
            stopWatch.time("retrieveSequenceInformation", () -> {
                retrieverExtra.retrieveSequenceInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion));
                return null;
            });
            stopWatch.time("filterAndSortSequences", () -> {
                this.catalog.reduce(Sequence.class, ReducerFactory.getSequenceReducer(this.options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving sequence information", e);
        }
    }

    private void crawlSynonyms() throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!infoLevel.is(SchemaInfoRetrieval.retrieveSynonymInformation) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlSynonyms");
        LOGGER.log(Level.INFO, "Crawling synonyms");
        try {
            SynonymRetriever retrieverExtra = new SynonymRetriever(this.retrieverConnection, this.catalog, this.options);
            stopWatch.time("retrieveSynonymInformation", () -> {
                retrieverExtra.retrieveSynonymInformation(limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion));
                return null;
            });
            stopWatch.time("filterAndSortSynonms", () -> {
                this.catalog.reduce(Synonym.class, ReducerFactory.getSynonymReducer(this.options));
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving synonym information", e);
        }
    }

    private void crawlTables() throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = this.options.getLoadOptions().getSchemaInfoLevel();
        LimitOptions limitOptions = this.options.getLimitOptions();
        if (!infoLevel.is(SchemaInfoRetrieval.retrieveTables) || limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForTableInclusion)) {
            LOGGER.log(Level.INFO, "Not retrieving tables, since this was not requested");
            return;
        }
        StopWatch stopWatch = new StopWatch("crawlTables");
        LOGGER.log(Level.INFO, "Crawling tables");
        try {
            TableRetriever retriever = new TableRetriever(this.retrieverConnection, this.catalog, this.options);
            TableColumnRetriever columnRetriever = new TableColumnRetriever(this.retrieverConnection, this.catalog, this.options);
            ForeignKeyRetriever fkRetriever = new ForeignKeyRetriever(this.retrieverConnection, this.catalog, this.options);
            TableConstraintRetriever constraintRetriever = new TableConstraintRetriever(this.retrieverConnection, this.catalog, this.options);
            TableExtRetriever retrieverExtra = new TableExtRetriever(this.retrieverConnection, this.catalog, this.options);
            stopWatch.time("retrieveTables", () -> {
                LOGGER.log(Level.INFO, "Retrieving table names");
                NamedObjectList<SchemaReference> schemas = retriever.getAllSchemas();
                retriever.retrieveTables(schemas, limitOptions.getTableNamePattern(), limitOptions.getTableTypes(), limitOptions.get(DatabaseObjectRuleForInclusion.ruleForTableInclusion));
                return null;
            });
            NamedObjectList<MutableTable> allTables = this.catalog.getAllTables();
            LOGGER.log(Level.INFO, new StringFormat("Retrieved %d tables", allTables.size()));
            if (allTables.isEmpty()) {
                return;
            }
            stopWatch.time("retrieveColumns", () -> {
                LOGGER.log(Level.INFO, "Retrieving table columns");
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableColumns) && !limitOptions.isExcludeAll(DatabaseObjectRuleForInclusion.ruleForColumnInclusion)) {
                    columnRetriever.retrieveTableColumns(allTables, limitOptions.get(DatabaseObjectRuleForInclusion.ruleForColumnInclusion));
                }
                return null;
            });
            stopWatch.time("retrieveForeignKeys", () -> {
                LOGGER.log(Level.INFO, "Retrieving foreign keys");
                if (infoLevel.is(SchemaInfoRetrieval.retrieveForeignKeys)) {
                    if (infoLevel.is(SchemaInfoRetrieval.retrieveTableColumns)) {
                        fkRetriever.retrieveForeignKeys(allTables);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "Foreign-keys are not being retrieved, so tables cannot be sorted using the natural sort order");
                }
                return null;
            });
            stopWatch.time("filterAndSortTables", () -> {
                this.catalog.reduce(Table.class, ReducerFactory.getTableReducer(this.options));
                TablesGraph tablesGraph = new TablesGraph(allTables);
                tablesGraph.setTablesSortIndexes();
                return null;
            });
            stopWatch.time("retrievePrimaryKeys", () -> {
                LOGGER.log(Level.INFO, "Retrieving primary keys");
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableColumns)) {
                    PrimaryKeyRetriever primaryKeyRetriever = new PrimaryKeyRetriever(this.retrieverConnection, this.catalog, this.options);
                    primaryKeyRetriever.retrievePrimaryKeys(allTables);
                }
                return null;
            });
            stopWatch.time("retrieveIndexes", () -> {
                LOGGER.log(Level.INFO, "Retrieving indexes");
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableColumns) && infoLevel.is(SchemaInfoRetrieval.retrieveIndexes)) {
                    IndexRetriever indexRetriever = new IndexRetriever(this.retrieverConnection, this.catalog, this.options);
                    indexRetriever.retrieveIndexes(allTables);
                }
                return null;
            });
            LOGGER.log(Level.INFO, "Retrieving additional table information");
            stopWatch.time("retrieveTableConstraintInformation", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableConstraintInformation)) {
                    constraintRetriever.retrieveTableConstraintInformation();
                }
                return null;
            });
            stopWatch.time("isRetrieveTableConstraintDefinitions", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableConstraintDefinitions)) {
                    constraintRetriever.retrieveTableConstraintDefinitions();
                }
                return null;
            });
            stopWatch.time("retrieveTriggerInformation", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTriggerInformation)) {
                    retrieverExtra.retrieveTriggerInformation();
                }
                return null;
            });
            stopWatch.time("retrieveViewInformation", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveViewInformation)) {
                    retrieverExtra.retrieveViewInformation();
                }
                return null;
            });
            stopWatch.time("retrieveViewTableUsage", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveViewTableUsage)) {
                    retrieverExtra.retrieveViewTableUsage();
                }
                return null;
            });
            stopWatch.time("retrieveTableDefinitions", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableDefinitionsInformation)) {
                    retrieverExtra.retrieveTableDefinitions();
                }
                return null;
            });
            stopWatch.time("retrieveIndexInformation", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveIndexInformation)) {
                    retrieverExtra.retrieveIndexInformation();
                }
                return null;
            });
            stopWatch.time("retrieveAdditionalTableAttributes", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveAdditionalTableAttributes)) {
                    retrieverExtra.retrieveAdditionalTableAttributes();
                }
                return null;
            });
            stopWatch.time("retrieveTablePrivileges", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTablePrivileges)) {
                    retrieverExtra.retrieveTablePrivileges();
                }
                return null;
            });
            stopWatch.time("retrieveAdditionalColumnAttributes", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes)) {
                    retrieverExtra.retrieveAdditionalColumnAttributes();
                }
                return null;
            });
            stopWatch.time("retrieveAdditionalColumnMetadata", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveAdditionalColumnMetadata)) {
                    retrieverExtra.retrieveAdditionalColumnMetadata();
                }
                return null;
            });
            stopWatch.time("retrieveTableColumnPrivileges", () -> {
                if (infoLevel.is(SchemaInfoRetrieval.retrieveTableColumnPrivileges)) {
                    retrieverExtra.retrieveTableColumnPrivileges();
                }
                return null;
            });
            LOGGER.log(Level.INFO, stopWatch.stringify());
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving table information", e);
        }
    }
}

