/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import schemacrawler.crawl.AbstractColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TableReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Table;

final class MutableColumn
extends AbstractColumn<Table>
implements Column {
    private static final long serialVersionUID = 3834591019449528633L;
    private final NamedObjectList<MutablePrivilege<Column>> privileges = new NamedObjectList();
    private String defaultValue;
    private boolean isAutoIncremented;
    private boolean isGenerated;
    private boolean isHidden;
    private boolean isPartOfIndex;
    private boolean isPartOfPrimaryKey;
    private boolean isPartOfUniqueIndex;
    private Column referencedColumn;

    MutableColumn(Table parent, String name) {
        super(new TableReference(parent), name);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Collection<Privilege<Column>> getPrivileges() {
        return new ArrayList<Privilege<Column>>(this.privileges.values());
    }

    @Override
    public Column getReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.isAutoIncremented;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.referencedColumn != null;
    }

    @Override
    public boolean isPartOfIndex() {
        return this.isPartOfIndex;
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.isPartOfPrimaryKey;
    }

    @Override
    public boolean isPartOfUniqueIndex() {
        return this.isPartOfUniqueIndex;
    }

    public Optional<MutablePrivilege<Column>> lookupPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    void addPrivilege(MutablePrivilege<Column> privilege) {
        this.privileges.add(privilege);
    }

    void markAsPartOfIndex() {
        this.isPartOfIndex = true;
    }

    void markAsPartOfPrimaryKey() {
        this.isPartOfPrimaryKey = true;
    }

    void markAsPartOfUniqueIndex() {
        this.isPartOfUniqueIndex = true;
    }

    void setAutoIncremented(boolean isAutoIncremented) {
        this.isAutoIncremented = isAutoIncremented;
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    void setReferencedColumn(Column referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

