/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.strings.domain;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Charsets;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.commonmark.Extension;
import shadow.org.commonmark.ext.gfm.tables.TablesExtension;
import shadow.org.commonmark.node.Link;
import shadow.org.commonmark.node.Node;
import shadow.org.commonmark.node.Paragraph;
import shadow.org.commonmark.parser.Parser;
import shadow.org.commonmark.renderer.html.CoreHtmlNodeRenderer;
import shadow.org.commonmark.renderer.html.HtmlRenderer;

public class StringTemplateFilters {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringTemplateFilters.class);
    static final Set<Extension> EXTENSIONS = Collections.singleton(TablesExtension.create());
    static final Parser parser = Parser.builder().extensions(EXTENSIONS).build();
    static final HtmlRenderer renderer = HtmlRenderer.builder().extensions(EXTENSIONS).nodeRendererFactory(context -> new CoreHtmlNodeRenderer(context){

        @Override
        public void visit(Paragraph paragraph) {
            this.visitChildren(paragraph);
        }
    }).attributeProviderFactory(context -> (node, tagName, attributes) -> {
        if (node instanceof Link) {
            attributes.put("target", "_blank");
        }
    }).build();
    static Pattern valuePattern = Pattern.compile("\\{\\{([\\w.]+)( ?\\| ?[\\w]+(:'[^']*')*)*\\}\\}");
    static Pattern filterPattern = Pattern.compile(" ?\\| ?([\\w]+)((?::'[^']*')*)");

    public static String applyFilterMarkdown(String value) {
        Node document = parser.parse(value);
        return renderer.render(document);
    }

    public static String applyTemplate(String template, String value) {
        return StringTemplateFilters.applyTemplate(template, value, (Boolean isHtml) -> {});
    }

    public static String applyTemplate(String template, String value, Consumer<Boolean> isHtml) {
        return StringTemplateFilters.applyTemplate(template, value, isHtml, "value");
    }

    public static String applyTemplate(String template, String value, Consumer<Boolean> isHtml, String valueSubst) {
        if (Objects.isNull(value) || value.isEmpty()) {
            return "";
        }
        if (Objects.isNull(template) || template.isEmpty()) {
            return value;
        }
        return StringTemplateFilters.applyTemplate(template, isHtml, (String key) -> Objects.equals(key, valueSubst) ? value : null);
    }

    public static String applyTemplate(String template, Function<String, String> valueLookup) {
        return StringTemplateFilters.applyTemplate(template, (Boolean isHtml) -> {}, valueLookup);
    }

    public static String applyTemplate(String template, Consumer<Boolean> isHtml, Function<String, String> valueLookup) {
        if (Objects.isNull(template) || template.isEmpty()) {
            return "";
        }
        Object formattedValue = "";
        Matcher matcher = valuePattern.matcher(template);
        boolean hasAppliedMarkdown = false;
        HashMap<String, Object> assigns = new HashMap<String, Object>();
        int lastMatch = 0;
        while (matcher.find()) {
            String key = matcher.group(1);
            Object filteredValue = valueLookup.apply(key);
            if (Objects.nonNull(filteredValue)) {
                Matcher matcher2 = filterPattern.matcher(template.substring(matcher.start(), matcher.end()));
                while (matcher2.find()) {
                    ImmutableList parameters;
                    String filter = matcher2.group(1);
                    String params = matcher2.group(2);
                    List<Object> list = parameters = matcher2.groupCount() < 2 ? ImmutableList.of() : Splitter.onPattern("(?<=^|'):(?='|$)").omitEmptyStrings().splitToList(params).stream().map(s -> s.substring(1, s.length() - 1)).collect(Collectors.toList());
                    if (filter.equals("markdown")) {
                        filteredValue = StringTemplateFilters.applyFilterMarkdown((String)filteredValue);
                        hasAppliedMarkdown = true;
                        continue;
                    }
                    if (filter.equals("replace") && parameters.size() >= 2) {
                        filteredValue = ((String)filteredValue).replaceAll((String)parameters.get(0), (String)parameters.get(1));
                        continue;
                    }
                    if (filter.equals("prepend") && parameters.size() >= 1) {
                        filteredValue = (String)parameters.get(0) + (String)filteredValue;
                        continue;
                    }
                    if (filter.equals("append") && parameters.size() >= 1) {
                        filteredValue = (String)filteredValue + (String)parameters.get(0);
                        continue;
                    }
                    if (filter.equals("urlEncode") || filter.equals("urlencode")) {
                        try {
                            filteredValue = URLEncoder.encode((String)filteredValue, Charsets.UTF_8.toString());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        continue;
                    }
                    if (filter.equals("toLower")) {
                        filteredValue = ((String)filteredValue).toLowerCase();
                        continue;
                    }
                    if (filter.equals("toUpper")) {
                        filteredValue = ((String)filteredValue).toUpperCase();
                        continue;
                    }
                    if (filter.equals("assignTo") && parameters.size() >= 1) {
                        assigns.put((String)parameters.get(0), filteredValue);
                        continue;
                    }
                    if (filter.equals("unHtml")) {
                        filteredValue = ((String)filteredValue).replaceAll("<.*?>", "");
                        continue;
                    }
                    LOGGER.warn("Template filter '{}' not supported", (Object)filter);
                }
            }
            formattedValue = (String)formattedValue + template.substring(lastMatch, matcher.start()) + Objects.requireNonNullElse(filteredValue, "");
            lastMatch = matcher.end();
        }
        formattedValue = (String)formattedValue + template.substring(lastMatch);
        for (Map.Entry entry : assigns.entrySet()) {
            String valueSubst2 = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            formattedValue = ((String)formattedValue).replaceAll("\\{\\{" + valueSubst2 + "}}", value2);
        }
        isHtml.accept(hasAppliedMarkdown);
        return formattedValue;
    }
}

