/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.domain;

import de.ii.xtraplatform.streams.app.SinkDefault;
import de.ii.xtraplatform.streams.app.SinkTransformedImpl;
import de.ii.xtraplatform.streams.app.SourceDefault;
import de.ii.xtraplatform.streams.app.TransformerChained;
import de.ii.xtraplatform.streams.app.TransformerDefault;
import de.ii.xtraplatform.streams.app.TransformerFused;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import shadow.org.reactivestreams.FlowAdapters;
import shadow.org.reactivestreams.Publisher;

public interface Reactive {
    public Runner runner(String var1);

    public Runner runner(String var1, int var2, int var3);

    public static interface Runner
    extends Closeable {
        public static final int DYNAMIC_CAPACITY = -1;

        public <X> CompletionStage<X> run(Stream<X> var1);

        public int getCapacity();
    }

    public static interface StreamContext<W> {
        public AtomicReference<W> getResult();

        public void onComplete(CompletableFuture<W> var1);

        public void onError(CompletableFuture<W> var1, Throwable var2);
    }

    public static interface RunnableStream<X> {
        public CompletionStage<X> run();
    }

    public static interface StreamWithResult<U, W>
    extends Stream<W> {
        public StreamWithResult<U, W> handleError(BiFunction<W, Throwable, W> var1);

        public StreamWithResult<U, W> handleItem(BiFunction<W, U, W> var1);

        public <X> Stream<X> handleEnd(Function<W, X> var1);
    }

    public static interface BasicStream<U, V>
    extends Stream<V> {
        public <W> StreamWithResult<U, W> withResult(W var1);
    }

    public static interface Stream<V> {
        public RunnableStream<V> on(Runner var1);
    }

    public static interface SinkReducedTransformed<T, U, V>
    extends SinkTransformed<T, U>,
    SinkReduced<T, V> {
    }

    public static interface SinkTransformed<T, U>
    extends Sink<T> {
    }

    public static interface SinkReduced<U, V>
    extends Sink<U> {
    }

    public static interface Sink<U> {
        public static <T> Sink<T> ignore() {
            return new SinkDefault(SinkDefault.Type.IGNORE);
        }

        public static <T> SinkReduced<T, T> head() {
            return new SinkDefault(SinkDefault.Type.HEAD);
        }

        public static <T> Sink<T> subscriber(Flow.Subscriber<T> subscriber) {
            return new SinkDefault(subscriber);
        }

        public static <T> Sink<T> foreach(Consumer<T> consumer) {
            return new SinkDefault(consumer);
        }

        public static <T, W> SinkReduced<T, W> reduce(W zero, BiFunction<W, T, W> reducer) {
            return new SinkDefault<T, W>(zero, reducer);
        }

        public static Sink<byte[]> outputStream(OutputStream outputStream) {
            return new SinkDefault(outputStream);
        }

        public static SinkReducedTransformed<byte[], byte[], byte[]> reduceByteArray() {
            Transformer<byte[], ByteArrayOutputStream> reduce = Transformer.reduce(new ByteArrayOutputStream(), (U outputStream, T bytes) -> {
                outputStream.writeBytes((byte[])bytes);
                return outputStream;
            });
            Transformer<ByteArrayOutputStream, byte[]> map = Transformer.map(ByteArrayOutputStream::toByteArray);
            return reduce.via(map).to(Sink.head());
        }
    }

    public static interface TransformerCustomSource<T, U, V extends Source<U>>
    extends TransformerCustom<T, U> {
        public V getCustomSource(Source<U> var1);
    }

    public static interface TransformerCustomFuseable<T, V>
    extends TransformerCustomFuseableIn<T, T, V>,
    TranformerCustomFuseableOut<T, T, V> {
    }

    public static interface TranformerCustomFuseableOut<T, U, V>
    extends TransformerCustom<T, U> {
        @Override
        default public <W> Transformer<T, W> via(Transformer<U, W> transformer) {
            if (transformer instanceof TransformerCustomFuseableIn && this.canFuse((TransformerCustomFuseableIn)transformer)) {
                return new TransformerFused(this, (TransformerCustomFuseableIn)transformer);
            }
            return TransformerCustom.super.via(transformer);
        }

        public Class<? extends V> getFusionInterface();

        public void fuse(TransformerCustomFuseableIn<U, ?, ? extends V> var1);

        default public boolean canFuse(TransformerCustomFuseableIn<U, ?, ?> transformerCustomFuseableIn) {
            return this.getFusionInterface().isAssignableFrom(transformerCustomFuseableIn.fuseableSink().getClass());
        }
    }

    public static interface TransformerCustomFuseableIn<T, U, V>
    extends TransformerCustom<T, U> {
        public V fuseableSink();

        public void afterInit(Runnable var1);
    }

    public static interface TransformerCustom<T, U>
    extends Transformer<T, U> {
        @Override
        default public <V> Transformer<T, V> via(Transformer<U, V> transformer) {
            return new TransformerChained(this, transformer);
        }

        public void init(Consumer<U> var1);

        public void onPush(T var1);

        public void onComplete();
    }

    public static interface Transformer<T, U> {
        default public <V> Transformer<T, V> via(Transformer<U, V> transformer) {
            return new TransformerChained(this, transformer);
        }

        default public <W> SinkReducedTransformed<T, U, W> to(SinkReduced<U, W> sink) {
            return new SinkTransformedImpl(this, sink);
        }

        default public <W, X> SinkReducedTransformed<T, X, W> to(SinkReducedTransformed<U, X, W> sink) {
            if (sink instanceof SinkTransformedImpl) {
                SinkReducedTransformed merge = this.merge((SinkTransformedImpl)sink);
                return merge;
            }
            throw new UnsupportedOperationException();
        }

        default public <V, W> SinkReducedTransformed<T, V, W> merge(SinkTransformedImpl<U, V, W> sink) {
            Transformer<U, V> transformer = sink.getTransformer();
            SinkReduced<V, W> sink1 = sink.getSink();
            Transformer<T, V> via = this.via(transformer);
            SinkReducedTransformed<T, V, W> to = via.to(sink1);
            return to;
        }

        default public SinkTransformed<T, U> to(Sink<U> sink) {
            return this.to((SinkReduced)sink);
        }

        default public Transformer<T, U> prepend(Source<U> other) {
            throw new UnsupportedOperationException();
        }

        default public Transformer<T, U> mergeSorted(Source<U> other, Comparator<U> comparator) {
            throw new UnsupportedOperationException();
        }

        public static <T, U> Transformer<T, U> map(Function<T, U> function) {
            return new TransformerDefault<T, U>(function);
        }

        public static <T> Transformer<T, T> filter(Predicate<T> predicate) {
            return new TransformerDefault(predicate);
        }

        public static <T> Transformer<T, T> peek(Consumer<T> consumer) {
            return new TransformerDefault(consumer);
        }

        public static <T, U> Transformer<T, U> reduce(U zero, BiFunction<U, T, U> reducer) {
            return new TransformerDefault<T, U>(zero, reducer);
        }

        public static <T, U> Transformer<T, U> flatMap(Function<T, Source<U>> flatMap) {
            return new TransformerDefault<T, U>(flatMap, true);
        }
    }

    public static interface Source<T> {
        public <U> Source<U> via(Transformer<T, U> var1);

        default public <U, V extends Source<U>> V via(TransformerCustomSource<T, U, V> transformer) {
            return transformer.getCustomSource(this.via((Transformer<T, U>)transformer));
        }

        public <V> BasicStream<T, V> to(SinkReduced<T, V> var1);

        default public BasicStream<T, Void> to(Sink<T> sink) {
            return this.to((SinkReduced)sink);
        }

        public <V, W> BasicStream<V, W> to(SinkReducedTransformed<T, V, W> var1);

        default public <V> BasicStream<V, Void> to(SinkTransformed<T, V> sink) {
            return this.to((SinkReducedTransformed)sink);
        }

        public Source<T> mapError(Function<Throwable, Throwable> var1);

        public Source<T> prepend(Source<T> var1);

        public Source<T> mergeSorted(Source<T> var1, Comparator<T> var2);

        public static <T> Source<T> iterable(Iterable<T> iterable) {
            return new SourceDefault<Iterable<T>>(iterable);
        }

        public static <T> Source<T> publisher(Publisher<T> publisher) {
            return new SourceDefault<Publisher<T>>(publisher);
        }

        public static <T> Source<T> publisher(Flow.Publisher<T> publisher) {
            return new SourceDefault<Publisher<T>>(FlowAdapters.toPublisher(publisher));
        }

        public static <T> Source<T> single(T item) {
            return new SourceDefault<T>(item);
        }

        public static Source<byte[]> inputStream(InputStream inputStream) {
            return new SourceDefault<byte[]>(inputStream);
        }
    }
}

