/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.domain;

import de.ii.xtraplatform.streams.domain.Event;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import shadow.io.reactivex.rxjava3.core.BackpressureStrategy;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableEmitter;

public class EventStream<T extends Event> {
    private final Reactive.Runner streamRunner;
    private final String eventType;
    private final Queue<T> eventQueue;
    private final Flowable<T> eventStream;
    private FlowableEmitter<T> emitter;

    public EventStream(Reactive.Runner streamRunner, String eventType) {
        this.streamRunner = streamRunner;
        this.eventType = eventType;
        this.eventQueue = new ConcurrentLinkedQueue<T>();
        this.eventStream = Flowable.create(emitter -> {
            this.eventQueue.forEach(emitter::onNext);
            this.emitter = emitter;
        }, BackpressureStrategy.BUFFER);
    }

    public void foreach(Consumer<T> eventConsumer) {
        Reactive.Source.publisher(this.eventStream).to(Reactive.Sink.foreach(eventConsumer)).on(this.streamRunner).run();
    }

    public synchronized void queue(T event) {
        if (Objects.nonNull(this.emitter)) {
            this.emitter.onNext(event);
        }
        this.eventQueue.offer(event);
    }

    public String getEventType() {
        return this.eventType;
    }
}

