/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.app;

import de.ii.xtraplatform.streams.app.TransformerChained;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransformerDefault<T, U>
implements Reactive.Transformer<T, U> {
    private final Type type;
    private final Function<T, U> function;
    private final Predicate<T> predicate;
    private final Consumer<T> consumer;
    private final U item;
    private final BiFunction<U, T, U> reducer;
    private final Function<T, Reactive.Source<U>> flatMap;
    private Reactive.Source<U> prepend;
    private Reactive.Source<U> mergeSorted;
    private Comparator<U> mergeSortedComparator;

    public TransformerDefault(Function<T, U> function) {
        this(Type.MAP, function, null, null, null, null, null);
    }

    public TransformerDefault(Function<T, Reactive.Source<U>> function, boolean flatMap) {
        this(Type.FLATMAP, null, null, null, null, null, function);
    }

    public TransformerDefault(Predicate<T> predicate) {
        this(Type.FILTER, null, predicate, null, null, null, null);
    }

    public TransformerDefault(Consumer<T> consumer) {
        this(Type.PEEK, null, null, consumer, null, null, null);
    }

    public TransformerDefault(U item, BiFunction<U, T, U> reducer) {
        this(Type.REDUCE, null, null, null, item, reducer, null);
    }

    TransformerDefault(Type type, Function<T, U> function, Predicate<T> predicate, Consumer<T> consumer, U item, BiFunction<U, T, U> reducer, Function<T, Reactive.Source<U>> flatMap) {
        this.type = type;
        this.function = function;
        this.predicate = predicate;
        this.consumer = consumer;
        this.item = item;
        this.reducer = reducer;
        this.flatMap = flatMap;
    }

    @Override
    public <V> Reactive.Transformer<T, V> via(Reactive.Transformer<U, V> transformer) {
        return new TransformerChained(this, transformer);
    }

    @Override
    public Reactive.Transformer<T, U> prepend(Reactive.Source<U> other) {
        this.prepend = other;
        return this;
    }

    @Override
    public Reactive.Transformer<T, U> mergeSorted(Reactive.Source<U> other, Comparator<U> comparator) {
        this.mergeSorted = other;
        this.mergeSortedComparator = comparator;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Function<T, U> getFunction() {
        return this.function;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    public U getItem() {
        return this.item;
    }

    public BiFunction<U, T, U> getReducer() {
        return this.reducer;
    }

    public Function<T, Reactive.Source<U>> getFlatMap() {
        return this.flatMap;
    }

    public Optional<Reactive.Source<U>> getPrepend() {
        return Optional.ofNullable(this.prepend);
    }

    public Optional<Reactive.Source<U>> getMergeSorted() {
        return Optional.ofNullable(this.mergeSorted);
    }

    public Optional<Comparator<U>> getMergeSortedComparator() {
        return Optional.ofNullable(this.mergeSortedComparator);
    }

    public static enum Type {
        MAP,
        FILTER,
        PEEK,
        REDUCE,
        FLATMAP;

    }
}

