/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.app;

import de.ii.xtraplatform.streams.app.SinkDefault;
import de.ii.xtraplatform.streams.app.SinkTransformedImpl;
import de.ii.xtraplatform.streams.app.SourceDefault;
import de.ii.xtraplatform.streams.app.SourceTransformed;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StreamDefault<V, W>
implements Reactive.BasicStream<V, W>,
Reactive.StreamWithResult<V, W>,
Reactive.StreamContext<W> {
    private final Reactive.Source<V> source;
    private final Reactive.SinkReduced<V, W> sink;
    private final AtomicReference<W> result;
    private final List<Function<Throwable, Throwable>> errorMappers;
    private Optional<BiFunction<W, Throwable, W>> errorHandler;
    private Optional<BiFunction<W, V, W>> itemHandler;

    public StreamDefault(Reactive.Source<V> source, Reactive.SinkReduced<V, W> sink) {
        this(source, sink, sink instanceof SinkDefault ? ((SinkDefault)sink).getItem().get() : (sink instanceof SinkTransformedImpl ? ((SinkTransformedImpl)sink).getItem().get() : null));
    }

    StreamDefault(Reactive.Source<V> source, Reactive.SinkReduced<V, W> sink, W initialResult) {
        this.source = source;
        this.sink = sink;
        this.result = new AtomicReference<W>(initialResult);
        this.errorMappers = new ArrayList<Function<Throwable, Throwable>>();
        this.errorHandler = Optional.empty();
        this.itemHandler = Optional.empty();
        if (source instanceof SourceDefault) {
            ((SourceDefault)source).getErrorMapper().ifPresent(this.errorMappers::add);
        } else if (source instanceof SourceTransformed) {
            ((SourceTransformed)source).getSource().getErrorMapper().ifPresent(this.errorMappers::add);
        }
    }

    @Override
    public Reactive.RunnableStream<W> on(Reactive.Runner runner) {
        return new RunnableStreamDefault(runner, this);
    }

    @Override
    public <W1> Reactive.StreamWithResult<V, W1> withResult(W1 initial) {
        if (this.sink instanceof SinkTransformedImpl) {
            boolean bl = true;
        }
        return new StreamDefault<V, W1>(this.source, ((SinkDefault)this.sink).withResult(initial), initial);
    }

    @Override
    public Reactive.StreamWithResult<V, W> handleError(BiFunction<W, Throwable, W> errorHandler) {
        this.errorHandler = Optional.of(errorHandler);
        return this;
    }

    @Override
    public Reactive.StreamWithResult<V, W> handleItem(BiFunction<W, V, W> itemHandler) {
        this.itemHandler = Optional.of(itemHandler);
        return this;
    }

    @Override
    public <X> Reactive.Stream<X> handleEnd(Function<W, X> finalizer) {
        return new WithFinalizer<X>(finalizer);
    }

    public Reactive.Source<V> getSource() {
        return this.source;
    }

    public Reactive.SinkReduced<V, W> getSink() {
        return this.sink;
    }

    @Override
    public AtomicReference<W> getResult() {
        return this.result;
    }

    public Optional<BiFunction<W, Throwable, W>> getErrorHandler() {
        return this.errorHandler;
    }

    public Optional<BiFunction<W, V, W>> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void onComplete(CompletableFuture<W> resultFuture) {
        if (this.sink instanceof SinkDefault && ((SinkDefault)this.sink).getType() == SinkDefault.Type.HEAD) {
            resultFuture.complete(((SinkDefault)this.sink).getHead().get());
        } else {
            resultFuture.complete(this.result.get());
        }
    }

    @Override
    public void onError(CompletableFuture<W> resultFuture, Throwable throwable) {
        Throwable actualThrowable = throwable instanceof CompletionException && Objects.nonNull(throwable.getCause()) ? throwable.getCause() : throwable;
        for (Function<Throwable, Throwable> mapper : this.errorMappers) {
            actualThrowable = mapper.apply(actualThrowable);
        }
        if (this.errorHandler.isPresent()) {
            try {
                resultFuture.complete(this.errorHandler.get().apply(this.result.get(), actualThrowable));
            }
            catch (Throwable handlerThrowable) {
                resultFuture.completeExceptionally(handlerThrowable);
            }
        } else {
            resultFuture.completeExceptionally(actualThrowable);
        }
    }

    private static class RunnableStreamDefault<X>
    implements Reactive.RunnableStream<X> {
        private final Reactive.Runner runner;
        private final Reactive.Stream<X> stream;

        RunnableStreamDefault(Reactive.Runner runner, Reactive.Stream<X> stream) {
            this.runner = runner;
            this.stream = stream;
        }

        @Override
        public CompletionStage<X> run() {
            return this.runner.run(this.stream);
        }
    }

    class WithFinalizer<X>
    implements Reactive.Stream<X>,
    Reactive.StreamContext<X> {
        private final Function<W, X> finalizer;

        WithFinalizer(Function<W, X> finalizer) {
            this.finalizer = finalizer;
        }

        @Override
        public Reactive.RunnableStream<X> on(Reactive.Runner runner) {
            return new RunnableStreamDefault(runner, this);
        }

        public StreamDefault<V, W> getStream() {
            return StreamDefault.this;
        }

        @Override
        public AtomicReference<X> getResult() {
            return null;
        }

        @Override
        public void onComplete(CompletableFuture<X> resultFuture) {
            try {
                X finalized = this.finalizer.apply(StreamDefault.this.result.get());
                resultFuture.complete(finalized);
            }
            catch (Throwable throwable) {
                resultFuture.completeExceptionally(throwable);
            }
        }

        @Override
        public void onError(CompletableFuture<X> result, Throwable throwable) {
            CompletableFuture resultFuture = new CompletableFuture();
            StreamDefault.this.onError(resultFuture, throwable);
            resultFuture.whenComplete((w, throwable1) -> {
                if (Objects.nonNull(throwable1)) {
                    result.completeExceptionally((Throwable)throwable1);
                } else {
                    try {
                        X finalized = this.finalizer.apply(w);
                        result.complete(finalized);
                    }
                    catch (Throwable throwable2) {
                        result.completeExceptionally(throwable2);
                    }
                }
            });
        }
    }
}

