/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.app;

import de.ii.xtraplatform.streams.app.SinkTransformedImpl;
import de.ii.xtraplatform.streams.app.SourceDefault;
import de.ii.xtraplatform.streams.app.StreamDefault;
import de.ii.xtraplatform.streams.app.TransformerChained;
import de.ii.xtraplatform.streams.app.TransformerFused;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

public class SourceTransformed<T, U>
implements Reactive.Source<U> {
    private final SourceDefault<T> source;
    private final Reactive.Transformer<T, U> transformer;

    public SourceTransformed(SourceDefault<T> source, Reactive.Transformer<T, U> transformer) {
        this.source = source;
        this.transformer = transformer;
    }

    @Override
    public <U1> Reactive.Source<U1> via(Reactive.Transformer<U, U1> transformer) {
        if (this.isFuseable(transformer)) {
            return new SourceTransformed<T, U1>(this.source, this.fuse(this.transformer, transformer));
        }
        return new SourceTransformed<T, U>(this.source, new TransformerChained<T, U, U1>(this.transformer, transformer));
    }

    @Override
    public <U1, W> Reactive.Source<W> via(TransformerChained<U, U1, W> transformer) {
        Reactive.Transformer<U, U1> transformer1 = transformer.getTransformer1();
        Reactive.Transformer<U1, W> transformer2 = transformer.getTransformer2();
        Reactive.Source<Object> via1 = transformer1 instanceof TransformerChained ? this.via((TransformerChained)transformer1) : this.via(transformer1);
        Reactive.Source<Object> via2 = transformer2 instanceof TransformerChained ? via1.via((TransformerChained)transformer2) : via1.via(transformer2);
        return via2;
    }

    @Override
    public <V> Reactive.BasicStream<U, V> to(Reactive.SinkReduced<U, V> sink) {
        return new StreamDefault<U, V>(this, sink);
    }

    @Override
    public <V, W> Reactive.BasicStream<V, W> to(Reactive.SinkReducedTransformed<U, V, W> sink) {
        if (sink instanceof SinkTransformedImpl) {
            Reactive.Transformer transformer = ((SinkTransformedImpl)sink).getTransformer();
            Reactive.SinkReduced sink1 = ((SinkTransformedImpl)sink).getSink();
            if (transformer instanceof TransformerChained) {
                return this.via((TransformerChained)transformer).to(sink1);
            }
            return this.via(transformer).to(sink1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Reactive.Source<U> mapError(Function<Throwable, Throwable> errorMapper) {
        this.source.mapError(errorMapper);
        return this;
    }

    @Override
    public Reactive.Source<U> prepend(Reactive.Source<U> other) {
        this.transformer.prepend(other);
        return this;
    }

    @Override
    public Reactive.Source<U> mergeSorted(Reactive.Source<U> other, Comparator<U> comparator) {
        this.transformer.mergeSorted(other, comparator);
        return this;
    }

    public SourceDefault<T> getSource() {
        return this.source;
    }

    public Reactive.Transformer<T, U> getTransformer() {
        return this.transformer;
    }

    private <U1> boolean isFuseable(Reactive.Transformer<U, U1> transformer) {
        Reactive.TranformerCustomFuseableOut fuseableOut = this.transformer instanceof Reactive.TranformerCustomFuseableOut ? (Reactive.TranformerCustomFuseableOut)this.transformer : (this.transformer instanceof TransformerChained && ((TransformerChained)this.transformer).getTransformer2() instanceof Reactive.TranformerCustomFuseableOut ? (Reactive.TranformerCustomFuseableOut)((TransformerChained)this.transformer).getTransformer2() : null);
        return transformer instanceof Reactive.TransformerCustomFuseableIn && Objects.nonNull(fuseableOut) && fuseableOut.canFuse((Reactive.TransformerCustomFuseableIn)transformer);
    }

    private <U1, U2, V> Reactive.Transformer<T, U1> fuse(Reactive.Transformer<T, U> transformer1, Reactive.Transformer<U, U1> transformer2) {
        Reactive.TransformerCustomFuseableIn in = (Reactive.TransformerCustomFuseableIn)transformer2;
        if (transformer1 instanceof Reactive.TranformerCustomFuseableOut) {
            Reactive.TranformerCustomFuseableOut out = (Reactive.TranformerCustomFuseableOut)transformer1;
            return new TransformerFused(out, in);
        }
        TransformerChained chained = (TransformerChained)transformer1;
        Reactive.Transformer other = chained.getTransformer1();
        Reactive.TranformerCustomFuseableOut out = (Reactive.TranformerCustomFuseableOut)chained.getTransformer2();
        return new TransformerChained(other, new TransformerFused(out, in));
    }
}

