/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.app;

import de.ii.xtraplatform.streams.app.SinkTransformedImpl;
import de.ii.xtraplatform.streams.app.SourceTransformed;
import de.ii.xtraplatform.streams.app.StreamDefault;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import shadow.org.reactivestreams.Publisher;

public class SourceDefault<T>
implements Reactive.Source<T> {
    private final Type type;
    private final Iterable<T> iterable;
    private final Publisher<T> publisher;
    private final T item;
    private final InputStream inputStream;
    private Optional<Function<Throwable, Throwable>> errorMapper;
    private Reactive.Source<T> prepend;
    private Reactive.Source<T> mergeSorted;
    private Comparator<T> mergeSortedComparator;

    public SourceDefault(Iterable<T> iterable) {
        this(Type.ITERABLE, iterable, null, null, null);
    }

    public SourceDefault(Publisher<T> publisher) {
        this(Type.PUBLISHER, null, publisher, null, null);
    }

    public SourceDefault(T item) {
        this(Type.SINGLE, null, null, item, null);
    }

    public SourceDefault(InputStream inputStream) {
        this(Type.INPUT_STREAM, null, null, null, inputStream);
    }

    SourceDefault(Type type, Iterable<T> iterable, Publisher<T> publisher, T item, InputStream inputStream) {
        this.type = type;
        this.iterable = iterable;
        this.publisher = publisher;
        this.item = item;
        this.inputStream = inputStream;
        this.errorMapper = Optional.empty();
    }

    @Override
    public <U> Reactive.Source<U> via(Reactive.Transformer<T, U> transformer) {
        return new SourceTransformed<T, U>(this, transformer);
    }

    @Override
    public <V> Reactive.BasicStream<T, V> to(Reactive.SinkReduced<T, V> sink) {
        return new StreamDefault<T, V>(this, sink);
    }

    @Override
    public <V, W> Reactive.BasicStream<V, W> to(Reactive.SinkReducedTransformed<T, V, W> sink) {
        if (sink instanceof SinkTransformedImpl) {
            return this.via(((SinkTransformedImpl)sink).getTransformer()).to(((SinkTransformedImpl)sink).getSink());
        }
        return null;
    }

    @Override
    public Reactive.Source<T> mapError(Function<Throwable, Throwable> errorMapper) {
        this.errorMapper = Optional.ofNullable(errorMapper);
        return this;
    }

    @Override
    public Reactive.Source<T> prepend(Reactive.Source<T> other) {
        if (Objects.nonNull(this.prepend)) {
            this.prepend.prepend(other);
        } else {
            this.prepend = other;
        }
        return this;
    }

    @Override
    public Reactive.Source<T> mergeSorted(Reactive.Source<T> other, Comparator<T> comparator) {
        if (Objects.nonNull(this.mergeSorted)) {
            this.mergeSorted.mergeSorted(other, comparator);
        } else {
            this.mergeSorted = other;
            this.mergeSortedComparator = comparator;
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public Publisher<T> getPublisher() {
        return this.publisher;
    }

    public T getItem() {
        return this.item;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Optional<Function<Throwable, Throwable>> getErrorMapper() {
        return this.errorMapper;
    }

    public Optional<Reactive.Source<T>> getPrepend() {
        return Optional.ofNullable(this.prepend);
    }

    public Optional<Reactive.Source<T>> getMergeSorted() {
        return Optional.ofNullable(this.mergeSorted);
    }

    public Optional<Comparator<T>> getMergeSortedComparator() {
        return Optional.ofNullable(this.mergeSortedComparator);
    }

    static enum Type {
        ITERABLE,
        PUBLISHER,
        SINGLE,
        INPUT_STREAM;

    }
}

