/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.streams.app;

import de.ii.xtraplatform.streams.domain.Reactive;
import java.io.OutputStream;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class SinkDefault<U, V>
implements Reactive.SinkReduced<U, V> {
    private final Type type;
    private final Flow.Subscriber<U> subscriber;
    private final Consumer<U> consumer;
    private final AtomicReference<U> head;
    private final AtomicReference<V> item;
    private final BiFunction<V, U, V> reducer;
    private final OutputStream outputStream;

    public SinkDefault(Type type) {
        this(type, null, null, null, null, null);
    }

    public SinkDefault(Flow.Subscriber<U> subscriber) {
        this(Type.SUBSCRIBER, subscriber, null, null, null, null);
    }

    public SinkDefault(Consumer<U> consumer) {
        this(Type.FOREACH, null, consumer, null, null, null);
    }

    public SinkDefault(V item, BiFunction<V, U, V> reducer) {
        this(Type.REDUCE, null, null, item, reducer, null);
    }

    public SinkDefault(OutputStream outputStream) {
        this(Type.OUTPUT_STREAM, null, null, null, null, outputStream);
    }

    SinkDefault(Type type, Flow.Subscriber<U> subscriber, Consumer<U> consumer, V item, BiFunction<V, U, V> reducer, OutputStream outputStream) {
        this.type = type;
        this.subscriber = subscriber;
        this.consumer = consumer;
        this.head = new AtomicReference();
        this.item = new AtomicReference<V>(item);
        this.reducer = reducer;
        this.outputStream = outputStream;
    }

    <V1> SinkDefault<U, V1> withResult(V1 item) {
        return new SinkDefault<U, V1>(this.type, this.subscriber, this.consumer, item, null, this.outputStream);
    }

    public Type getType() {
        return this.type;
    }

    public Flow.Subscriber<U> getSubscriber() {
        return this.subscriber;
    }

    public Consumer<U> getConsumer() {
        return this.consumer;
    }

    public AtomicReference<U> getHead() {
        return this.head;
    }

    public AtomicReference<V> getItem() {
        return this.item;
    }

    public BiFunction<V, U, V> getReducer() {
        return this.reducer;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public static enum Type {
        IGNORE,
        HEAD,
        SUBSCRIBER,
        FOREACH,
        REDUCE,
        OUTPUT_STREAM;

    }
}

