/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.infra;

import de.ii.xtraplatform.base.domain.AppContext;
import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.base.domain.StoreConfiguration;
import de.ii.xtraplatform.base.domain.util.LambdaWithException;
import de.ii.xtraplatform.store.app.EventPaths;
import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.EventStoreDriver;
import de.ii.xtraplatform.store.domain.Identifier;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.sun.nio.file.SensitivityWatchEventModifier;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class EventStoreDriverFs
implements EventStoreDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventStoreDriverFs.class);
    private static final String STORE_DIR_LEGACY = "config-store";
    private final Path storeDirectory;
    private final List<Path> additionalDirectories;
    private final EventPaths eventPaths;
    private final List<EventPaths> additionalEventPaths;
    private final boolean isEnabled;
    private final boolean isReadOnly;

    @Inject
    EventStoreDriverFs(AppContext appContext) {
        this(appContext.getDataDir(), appContext.getConfiguration().store);
    }

    public EventStoreDriverFs(Path dataDirectory, StoreConfiguration storeConfiguration) {
        this.storeDirectory = this.getStoreDirectory(dataDirectory, storeConfiguration);
        this.eventPaths = new EventPaths(this.storeDirectory, storeConfiguration.instancePathPattern, storeConfiguration.overridesPathPatterns, this::adjustPathPattern);
        this.isEnabled = true;
        this.isReadOnly = storeConfiguration.mode == StoreConfiguration.StoreMode.READ_ONLY;
        this.additionalDirectories = this.getAdditionalDirectories(dataDirectory, storeConfiguration);
        this.additionalEventPaths = this.additionalDirectories.stream().map(additionalDirectory -> new EventPaths((Path)additionalDirectory, storeConfiguration.instancePathPattern, storeConfiguration.overridesPathPatterns, this::adjustPathPattern)).collect(Collectors.toList());
    }

    private String adjustPathPattern(String pattern) {
        return pattern.replaceAll("\\/", "\\" + FileSystems.getDefault().getSeparator());
    }

    @Override
    public void start() {
        if (!this.isEnabled) {
            return;
        }
        if (!Files.exists(this.storeDirectory, new LinkOption[0]) && this.isReadOnly) {
            throw new IllegalArgumentException("Store path does not exist and cannot be created because store is read-only");
        }
        LOGGER.info("Store location: {}", (Object)this.storeDirectory.toAbsolutePath());
        if (!this.additionalEventPaths.isEmpty()) {
            LOGGER.info("Additional store locations: {}", (Object)this.additionalEventPaths.stream().map(EventPaths::getRootPath).map(Path::toAbsolutePath).collect(Collectors.toList()));
        }
        try {
            boolean usingLegacyStore;
            boolean usingNewStore = Files.isDirectory(this.storeDirectory, new LinkOption[0]) && Files.list(this.storeDirectory).findFirst().isPresent();
            Files.createDirectories(this.storeDirectory, new FileAttribute[0]);
            Path legacyStoreDirectory = this.storeDirectory.getParent().resolve(STORE_DIR_LEGACY);
            boolean bl = usingLegacyStore = Files.isDirectory(legacyStoreDirectory, new LinkOption[0]) && Files.list(legacyStoreDirectory).findFirst().isPresent();
            if (usingLegacyStore) {
                if (usingNewStore) {
                    LOGGER.warn("Found non-empty stores in '{}' and '{}'. Please merge manually and remove '{}'.", legacyStoreDirectory.toAbsolutePath(), this.storeDirectory.toAbsolutePath(), legacyStoreDirectory.toAbsolutePath());
                } else {
                    this.migrateStore(legacyStoreDirectory);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Stream<EntityEvent> loadEventStream() {
        if (!this.isEnabled) {
            return Stream.empty();
        }
        try {
            return Stream.concat(this.eventPaths.getPathPatternStream().flatMap(pathPattern -> this.loadPathStream(this.storeDirectory).map(path -> this.eventPaths.pathToEvent((Pattern)pathPattern, (Path)path, this::readPayload, false)).filter(Objects::nonNull)).sorted(Comparator.naturalOrder()), this.additionalEventPaths.stream().filter(additionalEventPath -> Files.exists(additionalEventPath.getRootPath(), new LinkOption[0])).flatMap(additionalEventPath -> additionalEventPath.getPathPatternStream().flatMap(pathPattern -> this.loadPathStream(additionalEventPath.getRootPath()).map(path -> additionalEventPath.pathToEvent((Pattern)pathPattern, (Path)path, this::readPayload, true)).filter(Objects::nonNull)).sorted(Comparator.naturalOrder())));
        }
        catch (Throwable e) {
            LogContext.error(LOGGER, e, "Reading events from '{}' failed", this.storeDirectory);
            return Stream.empty();
        }
    }

    @Override
    public boolean supportsWatch() {
        return true;
    }

    @Override
    public void startWatching(Consumer<List<Path>> watchEventConsumer) {
        if (!this.isEnabled) {
            return;
        }
        try {
            WatchKey key;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            HashMap<WatchKey, List<Path>> keys = new HashMap<WatchKey, List<Path>>();
            keys.putAll(this.watchDirectory(watchService, this.storeDirectory));
            for (Path additionalDirectory : this.additionalDirectories) {
                keys.putAll(this.watchDirectory(watchService, additionalDirectory));
            }
            while ((key = watchService.take()) != null) {
                if (!keys.containsKey(key)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("WatchKey " + key + " not recognized!");
                    continue;
                }
                Path rootDir = (Path)((List)keys.get(key)).get(0);
                Path watchDir = (Path)((List)keys.get(key)).get(1);
                List changedFiles = key.pollEvents().stream().filter(watchEvent -> watchEvent.context() instanceof Path).filter(watchEvent -> {
                    String fileExtension = shadow.com.google.common.io.Files.getFileExtension(watchEvent.context().toString());
                    return Objects.equals(fileExtension, "yml") || Objects.equals(fileExtension, "yaml") || Objects.equals(fileExtension, "json");
                }).map(watchEvent -> rootDir.relativize(watchDir.resolve((Path)watchEvent.context()))).collect(Collectors.toList());
                if (!changedFiles.isEmpty()) {
                    watchEventConsumer.accept(changedFiles);
                }
                key.reset();
            }
        }
        catch (IOException | InterruptedException e) {
            LogContext.error(LOGGER, e, "Could not watch directory {}", this.storeDirectory);
        }
    }

    private Map<WatchKey, List<Path>> watchDirectory(final WatchService watchService, final Path rootDir) throws IOException {
        final HashMap<WatchKey, List<Path>> keys = new HashMap<WatchKey, List<Path>>();
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchKey watchKey = dir.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, new WatchEvent.Modifier[]{SensitivityWatchEventModifier.HIGH});
                keys.put(watchKey, ImmutableList.of(rootDir, dir));
                return FileVisitResult.CONTINUE;
            }
        });
        return keys;
    }

    private Stream<Path> loadPathStream(Path directory) {
        try {
            return Files.find(directory, 32, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading event from store path failed", e);
        }
    }

    private byte[] readPayload(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading event from file failed", e);
        }
    }

    @Override
    public void saveEvent(EntityEvent event) throws IOException {
        Path eventPath = this.eventPaths.getSavePath(event);
        Files.createDirectories(eventPath.getParent(), new FileAttribute[0]);
        Files.write(eventPath, event.payload(), new OpenOption[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saved event to file {}", (Object)eventPath);
        }
    }

    @Override
    public void deleteAllEvents(String type, Identifier identifier, String format) throws IOException {
        for (Path path : this.eventPaths.getDeletePaths(type, identifier, format)) {
            this.deleteEvent(path);
        }
    }

    private void deleteEvent(Path eventPath) throws IOException {
        if (!Files.isDirectory(eventPath.getParent(), new LinkOption[0])) {
            return;
        }
        Files.list(eventPath.getParent()).forEach(LambdaWithException.consumerMayThrow(file -> {
            if (Files.isRegularFile(file, new LinkOption[0]) && (Objects.equals(eventPath, file) || file.getFileName().toString().startsWith(eventPath.getFileName().toString() + "."))) {
                String fileName = file.getFileName().toString();
                String name = file.toFile().getName();
                Path backup = file.getParent().endsWith("#overrides#") ? file.getParent().getParent().resolve(".backup/#overrides#") : file.getParent().resolve(".backup");
                Files.createDirectories(backup, new FileAttribute[0]);
                Files.copy(file, backup.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                Files.delete(file);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleted event file {}", (Object)eventPath);
                }
                if (file.getParent().endsWith("#overrides#")) {
                    try {
                        Files.delete(file.getParent());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                boolean bl = true;
            }
        }));
    }

    private Path getStoreDirectory(Path dataDir, StoreConfiguration storeConfiguration) {
        Path storeLocation = Paths.get(storeConfiguration.location, new String[0]);
        if (storeLocation.isAbsolute()) {
            if (storeConfiguration.mode == StoreConfiguration.StoreMode.READ_WRITE && !storeLocation.startsWith(dataDir)) {
                throw new IllegalStateException(String.format("Invalid store location (%s). READ_WRITE stores must reside inside the data directory (%s).", storeLocation, dataDir));
            }
            return storeLocation;
        }
        return dataDir.resolve(storeLocation);
    }

    private List<Path> getAdditionalDirectories(Path dataDir, StoreConfiguration storeConfiguration) {
        ImmutableList.Builder additionalDirectories = new ImmutableList.Builder();
        for (String additionalLocation : storeConfiguration.additionalLocations) {
            Path storeLocation = Paths.get(additionalLocation, new String[0]);
            if (storeLocation.isAbsolute()) {
                if (storeConfiguration.mode == StoreConfiguration.StoreMode.READ_WRITE && !storeLocation.startsWith(dataDir)) {
                    throw new IllegalStateException(String.format("Invalid store location (%s). READ_WRITE stores must reside inside the data directory (%s).", storeLocation, dataDir));
                }
                additionalDirectories.add(storeLocation);
                continue;
            }
            additionalDirectories.add(dataDir.resolve(storeLocation));
        }
        return additionalDirectories.build();
    }

    private void migrateStore(Path legacyStoreDirectory) {
        try {
            ArrayList directoriesToDelete = new ArrayList();
            Files.walk(legacyStoreDirectory, new FileVisitOption[0]).forEach(fileOrDirectory -> {
                try {
                    Path newFileOrDirectory = this.storeDirectory.resolve(legacyStoreDirectory.relativize((Path)fileOrDirectory));
                    if (Files.isDirectory(fileOrDirectory, new LinkOption[0])) {
                        if (Files.list(fileOrDirectory).findFirst().isPresent()) {
                            LOGGER.debug("Creating directory {}", (Object)newFileOrDirectory);
                            Files.createDirectories(newFileOrDirectory, new FileAttribute[0]);
                        }
                        directoriesToDelete.add(0, fileOrDirectory);
                    } else {
                        LOGGER.debug("Copying File {}", (Object)newFileOrDirectory);
                        Files.copy(fileOrDirectory, newFileOrDirectory, new CopyOption[0]);
                        Files.delete(fileOrDirectory);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage());
                }
            });
            for (Path path : directoriesToDelete) {
                Files.delete(path);
            }
            LOGGER.info("Migrated store from '{}' to '{}'", (Object)legacyStoreDirectory.toAbsolutePath(), (Object)this.storeDirectory.toAbsolutePath());
        }
        catch (Throwable e) {
            LogContext.error(LOGGER, e, "Error migrating store from '{}' to '{}': {}", legacyStoreDirectory.toAbsolutePath(), this.storeDirectory.toAbsolutePath());
        }
    }
}

