/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import java.util.List;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface ValidationResult {
    public static ValidationResult of() {
        return ImmutableValidationResult.builder().mode(MODE.NONE).build();
    }

    default public ValidationResult mergeWith(ValidationResult other) {
        return ImmutableValidationResult.builder().from(this).mode(other.getMode()).addAllErrors(other.getErrors()).addAllStrictErrors(other.getStrictErrors()).addAllWarnings(other.getWarnings()).build();
    }

    public MODE getMode();

    public List<String> getErrors();

    public List<String> getStrictErrors();

    public List<String> getWarnings();

    @Value.Derived
    default public boolean isSuccess() {
        return this.getErrors().isEmpty() && (this.getMode() == MODE.LAX || this.getStrictErrors().isEmpty());
    }

    public static enum MODE {
        NONE,
        LAX,
        STRICT;

    }
}

