/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValidationResult", generator="Immutables")
@Immutable
public final class ImmutableValidationResult
implements ValidationResult {
    private final ValidationResult.MODE mode;
    private final ImmutableList<String> errors;
    private final ImmutableList<String> strictErrors;
    private final ImmutableList<String> warnings;
    private final transient boolean isSuccess;

    private ImmutableValidationResult(ValidationResult.MODE mode, ImmutableList<String> errors, ImmutableList<String> strictErrors, ImmutableList<String> warnings) {
        this.mode = mode;
        this.errors = errors;
        this.strictErrors = strictErrors;
        this.warnings = warnings;
        this.isSuccess = ValidationResult.super.isSuccess();
    }

    @Override
    public ValidationResult.MODE getMode() {
        return this.mode;
    }

    public ImmutableList<String> getErrors() {
        return this.errors;
    }

    public ImmutableList<String> getStrictErrors() {
        return this.strictErrors;
    }

    public ImmutableList<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    public final ImmutableValidationResult withMode(ValidationResult.MODE value) {
        if (this.mode == value) {
            return this;
        }
        ValidationResult.MODE newValue = Objects.requireNonNull(value, "mode");
        if (this.mode.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableValidationResult(newValue, this.errors, this.strictErrors, this.warnings);
    }

    public final ImmutableValidationResult withErrors(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, newValue, this.strictErrors, this.warnings);
    }

    public final ImmutableValidationResult withErrors(Iterable<String> elements) {
        if (this.errors == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, newValue, this.strictErrors, this.warnings);
    }

    public final ImmutableValidationResult withStrictErrors(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, this.errors, newValue, this.warnings);
    }

    public final ImmutableValidationResult withStrictErrors(Iterable<String> elements) {
        if (this.strictErrors == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, this.errors, newValue, this.warnings);
    }

    public final ImmutableValidationResult withWarnings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, this.errors, this.strictErrors, newValue);
    }

    public final ImmutableValidationResult withWarnings(Iterable<String> elements) {
        if (this.warnings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableValidationResult(this.mode, this.errors, this.strictErrors, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidationResult && this.equalTo((ImmutableValidationResult)another);
    }

    private boolean equalTo(ImmutableValidationResult another) {
        return this.mode.equals((Object)another.mode) && this.errors.equals(another.errors) && this.strictErrors.equals(another.strictErrors) && this.warnings.equals(another.warnings) && this.isSuccess == another.isSuccess;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mode.hashCode();
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + this.strictErrors.hashCode();
        h += (h << 5) + this.warnings.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isSuccess);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ValidationResult").omitNullValues().add("mode", (Object)this.mode).add("errors", this.errors).add("strictErrors", this.strictErrors).add("warnings", this.warnings).add("isSuccess", this.isSuccess).toString();
    }

    public static ImmutableValidationResult copyOf(ValidationResult instance) {
        if (instance instanceof ImmutableValidationResult) {
            return (ImmutableValidationResult)instance;
        }
        return ImmutableValidationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValidationResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODE = 1L;
        private long initBits = 1L;
        @Nullable
        private ValidationResult.MODE mode;
        private ImmutableList.Builder<String> errors = ImmutableList.builder();
        private ImmutableList.Builder<String> strictErrors = ImmutableList.builder();
        private ImmutableList.Builder<String> warnings = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValidationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.mode(instance.getMode());
            this.addAllErrors(instance.getErrors());
            this.addAllStrictErrors(instance.getStrictErrors());
            this.addAllWarnings(instance.getWarnings());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mode(ValidationResult.MODE mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(String element) {
            this.errors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrors(String ... elements) {
            this.errors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errors(Iterable<String> elements) {
            this.errors = ImmutableList.builder();
            return this.addAllErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllErrors(Iterable<String> elements) {
            this.errors.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStrictErrors(String element) {
            this.strictErrors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStrictErrors(String ... elements) {
            this.strictErrors.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder strictErrors(Iterable<String> elements) {
            this.strictErrors = ImmutableList.builder();
            return this.addAllStrictErrors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStrictErrors(Iterable<String> elements) {
            this.strictErrors.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWarnings(String element) {
            this.warnings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWarnings(String ... elements) {
            this.warnings.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder warnings(Iterable<String> elements) {
            this.warnings = ImmutableList.builder();
            return this.addAllWarnings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllWarnings(Iterable<String> elements) {
            this.warnings.addAll((Iterable)elements);
            return this;
        }

        public ImmutableValidationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidationResult(this.mode, (ImmutableList<String>)this.errors.build(), (ImmutableList<String>)this.strictErrors.build(), (ImmutableList<String>)this.warnings.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mode");
            }
            return "Cannot build ValidationResult, some of required attributes are not set " + attributes;
        }
    }
}

