/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import dagger.Lazy;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;

public class EntityFactories {
    private final Lazy<Set<EntityFactory>> entityFactories;

    public EntityFactories(Lazy<Set<EntityFactory>> entityFactories) {
        this.entityFactories = entityFactories;
    }

    public EntityFactory get(String entityType) {
        return this.entityFactories.get().stream().filter(entityFactory -> entityFactory.type().equalsIgnoreCase(entityType)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No factory found for entity type %s", entityType)));
    }

    public EntityFactory get(String entityType, String subType) {
        return this.entityFactories.get().stream().filter(entityFactory -> entityFactory.type().equalsIgnoreCase(entityType) && entityFactory.subType().filter(entityFactorySubType -> entityFactorySubType.equalsIgnoreCase(subType)).isPresent()).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No factory found for entity type %s/%s", entityType, subType)));
    }

    public EntityFactory get(String entityType, Optional<String> subType) {
        return subType.isPresent() ? this.get(entityType, subType.get()) : this.get(entityType);
    }

    public EntityFactory get(Class<? extends EntityData> dataClass) {
        return this.entityFactories.get().stream().filter(entityFactory -> Objects.equals(dataClass, entityFactory.dataClass())).findFirst().orElseThrow(() -> new NoSuchElementException("No factory found for entity data class " + dataClass));
    }

    public Set<EntityFactory> getAll(Class<? extends PersistentEntity> entityClass) {
        return this.entityFactories.get().stream().filter(entityFactory -> entityClass.isAssignableFrom(entityFactory.entityClass())).collect(Collectors.toSet());
    }

    public Set<EntityFactory> getAll(String entityType) {
        return this.entityFactories.get().stream().filter(entityFactory -> Objects.equals(entityType, entityFactory.type())).collect(Collectors.toSet());
    }

    public List<String> getSubTypes(String entityType, List<String> entitySubType) {
        String specificEntityType = this.getSpecificEntityType(entityType, this.getTypeAsString(entitySubType));
        return this.entityFactories.get().stream().filter(entityFactory -> entityFactory.fullType().startsWith(specificEntityType) && !Objects.equals(entityFactory.fullType(), specificEntityType)).map(entityFactory -> entityFactory.subType().map(String::toLowerCase)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    private String getSpecificEntityType(String entityType, Optional<String> entitySubType) {
        return entitySubType.isPresent() ? String.format("%s/%s", entityType, entitySubType.get().toLowerCase()) : entityType;
    }

    public Optional<String> getTypeAsString(List<String> entitySubtype) {
        if (entitySubtype.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Joiner.on('/').join(entitySubtype));
    }
}

