/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.entities.ModifiableEntityDataOverridesPath;
import java.util.ArrayList;
import java.util.List;
import shadow.com.google.common.base.Splitter;
import shadow.org.immutables.value.Value;

@Value.Modifiable
public interface EntityDataOverridesPath {
    public static final Splitter DOT_SPLITTER = Splitter.on('.');

    public static EntityDataOverridesPath from(Identifier identifier) {
        ModifiableEntityDataOverridesPath overridesPath = ModifiableEntityDataOverridesPath.create();
        ArrayList<String> pathSegments = new ArrayList<String>();
        pathSegments.addAll(identifier.path());
        pathSegments.addAll(DOT_SPLITTER.splitToList(identifier.id()));
        if (pathSegments.size() < 2) {
            throw new IllegalArgumentException("Not a valid override path: " + identifier);
        }
        overridesPath.setEntityType((String)pathSegments.get(0));
        overridesPath.setEntityId((String)pathSegments.get(1));
        if (pathSegments.size() > 2) {
            overridesPath.setKeyPath(pathSegments.subList(2, pathSegments.size()));
        }
        return overridesPath;
    }

    public String getEntityType();

    public String getEntityId();

    public List<String> getKeyPath();
}

