/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.entities.ModifiableEntityDataDefaultsPath;
import java.util.List;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Modifiable
public interface EntityDataDefaultsPath {
    public static final Splitter DOT_SPLITTER = Splitter.on('.');

    public static EntityDataDefaultsPath from(Identifier identifier) {
        List<Object> pathSegments;
        ModifiableEntityDataDefaultsPath defaultsPath = ModifiableEntityDataDefaultsPath.create();
        if (identifier.path().isEmpty()) {
            if (identifier.id().contains(".")) {
                int firstDot = identifier.id().indexOf(".");
                defaultsPath.setEntityType(identifier.id().substring(0, firstDot));
                pathSegments = DOT_SPLITTER.splitToList(identifier.id().substring(firstDot + 1));
            } else {
                defaultsPath.setEntityType(identifier.id());
                pathSegments = ImmutableList.of();
            }
        } else {
            defaultsPath.setEntityType(identifier.path().get(0));
            pathSegments = identifier.path().subList(1, identifier.path().size());
        }
        if (!pathSegments.isEmpty()) {
            try {
                List<Object> subtype = pathSegments.subList(0, pathSegments.size());
                defaultsPath.setEntitySubtype(ImmutableList.of(Joiner.on('/').join(subtype)));
                if (!identifier.path().isEmpty()) {
                    defaultsPath.setKeyPath(ImmutableList.of(identifier.id()));
                }
            }
            catch (Throwable e) {
                List<Object> keyPath = pathSegments.subList(pathSegments.size() - 1, pathSegments.size());
                defaultsPath.setKeyPath(keyPath);
                defaultsPath.addKeyPath(identifier.id());
            }
        }
        return defaultsPath;
    }

    public String getEntityType();

    public List<String> getEntitySubtype();

    public List<String> getKeyPath();
}

