/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityState;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import de.ii.xtraplatform.store.domain.entities.Reloadable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import shadow.com.google.common.util.concurrent.MoreExecutors;
import shadow.com.google.common.util.concurrent.ThreadFactoryBuilder;

public abstract class AbstractPersistentEntity<T extends EntityData>
implements PersistentEntity,
Reloadable,
EntityState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPersistentEntity.class);
    private final ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("entity.lifecycle-%d").build()));
    private final List<Consumer<PersistentEntity>> reloadListeners = new CopyOnWriteArrayList<Consumer<PersistentEntity>>();
    private final List<Consumer<EntityState>> stateChangeListeners = new CopyOnWriteArrayList<Consumer<EntityState>>();
    private boolean registerState;
    public volatile boolean register;
    private T data;
    private Future<?> startup;
    private EntityState.STATE state;

    public AbstractPersistentEntity(T data) {
        this.data = data;
        this.startup = null;
        this.state = EntityState.STATE.UNKNOWN;
        this.setState(EntityState.STATE.LOADING);
    }

    public T getData() {
        return this.data;
    }

    public final void setData(T data) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("GOT DATA {}");
        }
        T previous = this.data;
        this.data = data;
        if (Objects.nonNull(previous)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RELOAD DATA {} {}", (Object)previous.hashCode(), (Object)data.hashCode());
            }
            this.onReload();
        }
    }

    public final void onValidate() {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (this.shouldRegister()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("STARTING {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
                }
                this.setState(EntityState.STATE.LOADING);
                this.triggerStartup(true, () -> {});
            } else {
                this.setState(EntityState.STATE.DISABLED);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("DISABLED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
                }
            }
        }
    }

    public final void onInvalidate() {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("STOPPING {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
            }
            this.cancelStartup();
            this.onShutdown();
        }
    }

    public final void onPostRegistration() {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("STARTED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
            }
            if (this.state == EntityState.STATE.LOADING) {
                this.onStarted();
                this.setState(EntityState.STATE.ACTIVE);
            }
        }
    }

    public final void onPostUnregistration() {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("STOPPED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
            }
            this.onStopped();
            this.setState(EntityState.STATE.DISABLED);
        }
    }

    private void onReload() {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RELOADING {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
            }
            this.setState(EntityState.STATE.RELOADING);
            this.cancelStartup();
            if (this.shouldRegister()) {
                this.triggerStartup(false, this::afterReload);
            } else {
                this.register = false;
                this.setState(EntityState.STATE.DISABLED);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("DISABLED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
                }
            }
        }
    }

    protected final void doReload() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("MANUAL RELOAD");
        }
        this.executorService.submit(() -> {
            LogContext.put(LogContext.CONTEXT.SERVICE, this.getId());
            this.onReload();
        });
    }

    private void afterReload() {
        this.reloadListeners.forEach(listener -> listener.accept(this));
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, this.getId());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RELOADED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register);
            }
            if (this.register) {
                this.onReloaded();
                this.setState(EntityState.STATE.ACTIVE);
            } else {
                LOGGER.trace("SUBSEQUENT FAILURE");
            }
        }
    }

    private void triggerStartup(boolean wait, Runnable then) {
        block3: {
            this.startup = this.executorService.submit(() -> {
                LogContext.put(LogContext.CONTEXT.SERVICE, this.getId());
                try {
                    this.register = this.onStartup();
                }
                catch (InterruptedException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("INTERRUPTED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register, e);
                    }
                    return;
                }
                catch (Throwable e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("DEFECTIVE {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register, e);
                    }
                    this.register = false;
                    this.onStartupFailure(e);
                    this.setState(EntityState.STATE.DEFECTIVE);
                }
                then.run();
            });
            if (wait) {
                try {
                    this.startup.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("INTERRUPTED {} {} {} {}", this.getType(), this.getId(), this.shouldRegister(), this.register, e);
                }
            }
        }
    }

    private void cancelStartup() {
        if (Objects.nonNull(this.startup)) {
            boolean bl = this.startup.cancel(true);
        }
    }

    protected boolean onStartup() throws InterruptedException {
        return true;
    }

    protected void onStarted() {
    }

    protected void onReloaded() {
    }

    protected void onShutdown() {
    }

    protected void onStopped() {
    }

    protected void onStartupFailure(Throwable throwable) {
    }

    protected boolean shouldRegister() {
        return true;
    }

    protected void checkForStartupCancel() throws InterruptedException {
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
    }

    public <U extends PersistentEntity> void addReloadListener(Class<U> type, Consumer<U> listener) {
        this.reloadListeners.add(entity -> {
            if (type.isAssignableFrom(entity.getClass())) {
                listener.accept((PersistentEntity)type.cast(entity));
            }
        });
    }

    @Override
    public String getId() {
        return PersistentEntity.super.getId();
    }

    @Override
    public String getEntityType() {
        return this.getType();
    }

    @Override
    public EntityState.STATE getState() {
        return this.state;
    }

    public void setState(EntityState.STATE state) {
        if (this.state != state) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}: {} -> {}", new Object[]{this.getId(), this.state, state});
            }
            this.state = state;
            this.stateChangeListeners.forEach(listener -> listener.accept(this));
        }
    }

    @Override
    public void addListener(Consumer<EntityState> listener) {
        this.stateChangeListeners.add(listener);
    }
}

