/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain.entities;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.store.domain.entities.AbstractPersistentEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.PersistentEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import shadow.com.google.common.collect.ImmutableSet;

public abstract class AbstractEntityFactory<T extends EntityData, U extends AbstractPersistentEntity<T>>
implements EntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEntityFactory.class);
    private final FactoryAssisted<T, U> assistedFactory;
    private final Map<String, U> instances;
    private final Map<String, Integer> instanceConfigurationHashes;
    private final List<Consumer<PersistentEntity>> entityListeners;
    private final List<Consumer<PersistentEntity>> entityGoneListeners;

    public AbstractEntityFactory(FactoryAssisted<T, U> assistedFactory) {
        this.assistedFactory = assistedFactory;
        this.instances = new LinkedHashMap<String, U>();
        this.instanceConfigurationHashes = new LinkedHashMap<String, Integer>();
        this.entityListeners = new ArrayList<Consumer<PersistentEntity>>();
        this.entityGoneListeners = new ArrayList<Consumer<PersistentEntity>>();
    }

    public Optional<U> instance(String id) {
        return Optional.ofNullable((AbstractPersistentEntity)this.instances.get(id));
    }

    public Set<U> instances() {
        return ImmutableSet.copyOf(this.instances.values());
    }

    @Override
    public CompletableFuture<PersistentEntity> createInstance(EntityData entityData) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("CREATING ENTITY {} {}", (Object)this.type(), (Object)entityData.getId());
        }
        AbstractPersistentEntity entity = (AbstractPersistentEntity)this.assistedFactory.create(entityData);
        this.instances.put(entityData.getId(), entity);
        this.instanceConfigurationHashes.put(entityData.getId(), entityData.hashCode());
        entity.onValidate();
        entity.onPostRegistration();
        this.entityListeners.forEach(listener -> listener.accept(entity));
        return CompletableFuture.completedFuture(entity);
    }

    @Override
    public CompletableFuture<PersistentEntity> updateInstance(EntityData entityData) {
        String id = entityData.getId();
        String entityTypeSingular = this.type().substring(0, this.type().length() - 1);
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, id);){
            if (Objects.equals(entityData.hashCode(), this.instanceConfigurationHashes.get(id))) {
                LOGGER.info("Not reloading configuration for {} with id '{}', no effective changes detected", (Object)entityTypeSingular, (Object)id);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            LOGGER.info("Reloading configuration for {} with id '{}'", (Object)entityTypeSingular, (Object)id);
            AbstractPersistentEntity instance = (AbstractPersistentEntity)this.instances.get(id);
            CompletableFuture<PersistentEntity> reloaded = new CompletableFuture<PersistentEntity>();
            if (Objects.nonNull(instance)) {
                try {
                    instance.setData(entityData);
                    this.instanceConfigurationHashes.put(id, entityData.hashCode());
                    reloaded.complete(instance);
                }
                catch (Throwable e) {
                    LogContext.error(LOGGER, e, "Could not reload configuration", new Object[0]);
                    reloaded.complete(null);
                }
            }
            CompletableFuture<PersistentEntity> completableFuture = reloaded;
            return completableFuture;
        }
    }

    @Override
    public void deleteInstance(String id) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("DELETING ENTITY {} {}", (Object)this.type(), (Object)id);
        }
        if (this.instances.containsKey(id)) {
            AbstractPersistentEntity entity = (AbstractPersistentEntity)this.instances.get(id);
            entity.onInvalidate();
            entity.onPostRegistration();
            this.instances.remove(id);
            this.instanceConfigurationHashes.remove(id);
            this.entityGoneListeners.forEach(listener -> listener.accept(entity));
        }
    }

    @Override
    public void addEntityListener(Consumer<PersistentEntity> listener, boolean existing) {
        this.entityListeners.add(listener);
        if (existing) {
            this.instances.values().forEach(listener);
        }
    }

    @Override
    public void addEntityGoneListener(Consumer<PersistentEntity> listener) {
        this.entityGoneListeners.add(listener);
    }

    public static interface FactoryAssisted<T extends EntityData, U extends PersistentEntity> {
        public U create(T var1);
    }
}

