/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.KeyPathAlias;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;

public interface ValueEncoding<T> {
    public ObjectMapper getMapper(FORMAT var1);

    public FORMAT getDefaultFormat();

    default public boolean isSupported(String format) {
        return FORMAT.fromString(format) != FORMAT.UNKNOWN;
    }

    public byte[] serialize(T var1);

    public byte[] serialize(Map<String, Object> var1);

    public T deserialize(Identifier var1, byte[] var2, FORMAT var3, boolean var4) throws IOException;

    public byte[] nestPayload(byte[] var1, String var2, List<String> var3, Optional<KeyPathAlias> var4) throws IOException;

    public static enum FORMAT {
        NONE,
        JSON,
        YML,
        YAML,
        UNKNOWN;


        public static FORMAT fromString(String format) {
            if (Objects.isNull(format)) {
                return NONE;
            }
            for (FORMAT f : FORMAT.values()) {
                if (!Objects.equals(f.name(), format.toUpperCase())) continue;
                return f;
            }
            return UNKNOWN;
        }
    }
}

