/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.StateChangeEvent;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StateChangeEvent", generator="Immutables")
@Immutable
public final class ImmutableStateChangeEvent
implements StateChangeEvent {
    private final StateChangeEvent.STATE state;
    private final String type;

    private ImmutableStateChangeEvent(StateChangeEvent.STATE state, String type) {
        this.state = state;
        this.type = type;
    }

    @Override
    public StateChangeEvent.STATE state() {
        return this.state;
    }

    @Override
    public String type() {
        return this.type;
    }

    public final ImmutableStateChangeEvent withState(StateChangeEvent.STATE value) {
        if (this.state == value) {
            return this;
        }
        StateChangeEvent.STATE newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableStateChangeEvent(newValue, this.type);
    }

    public final ImmutableStateChangeEvent withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableStateChangeEvent(this.state, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStateChangeEvent && this.equalTo((ImmutableStateChangeEvent)another);
    }

    private boolean equalTo(ImmutableStateChangeEvent another) {
        return this.state.equals((Object)another.state) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StateChangeEvent").omitNullValues().add("state", (Object)this.state).add("type", this.type).toString();
    }

    public static ImmutableStateChangeEvent copyOf(StateChangeEvent instance) {
        if (instance instanceof ImmutableStateChangeEvent) {
            return (ImmutableStateChangeEvent)instance;
        }
        return ImmutableStateChangeEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StateChangeEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private StateChangeEvent.STATE state;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StateChangeEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.type(instance.type());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder state(StateChangeEvent.STATE state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStateChangeEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStateChangeEvent(this.state, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build StateChangeEvent, some of required attributes are not set " + attributes;
        }
    }
}

