/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableIdentifier;
import de.ii.xtraplatform.store.domain.ReplayEvent;
import de.ii.xtraplatform.store.domain.TypedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReplayEvent", generator="Immutables")
@Immutable
public final class ImmutableReplayEvent
implements ReplayEvent {
    private final String type;
    private final ImmutableIdentifier identifier;
    @Nullable
    private final byte[] payload;
    @Nullable
    private final Boolean deleted;
    @Nullable
    private final String format;
    private final transient String asPath;
    @Nullable
    private final String additionalLocation;

    private ImmutableReplayEvent(String type, ImmutableIdentifier identifier, @Nullable byte[] payload, @Nullable Boolean deleted, @Nullable String format, @Nullable String additionalLocation) {
        this.type = type;
        this.identifier = identifier;
        this.payload = payload;
        this.deleted = deleted;
        this.format = format;
        this.additionalLocation = additionalLocation;
        this.asPath = Objects.requireNonNull(ReplayEvent.super.asPath(), "asPath");
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="identifier")
    public ImmutableIdentifier identifier() {
        return this.identifier;
    }

    @Override
    @JsonProperty(value="payload")
    @Nullable
    public byte[] payload() {
        return this.payload;
    }

    @Override
    @JsonProperty(value="deleted")
    @Nullable
    public Boolean deleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="format")
    @Nullable
    public String format() {
        return this.format;
    }

    @Override
    @JsonProperty(value="asPath")
    @JsonIgnore
    public String asPath() {
        return this.asPath;
    }

    @Override
    @JsonProperty(value="additionalLocation")
    @Nullable
    public String additionalLocation() {
        return this.additionalLocation;
    }

    public final ImmutableReplayEvent withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableReplayEvent(newValue, this.identifier, this.payload, this.deleted, this.format, this.additionalLocation);
    }

    public final ImmutableReplayEvent withIdentifier(Identifier value) {
        if (this.identifier == value) {
            return this;
        }
        ImmutableIdentifier newValue = ImmutableIdentifier.copyOf(value);
        return new ImmutableReplayEvent(this.type, newValue, this.payload, this.deleted, this.format, this.additionalLocation);
    }

    public final ImmutableReplayEvent withPayload(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableReplayEvent(this.type, this.identifier, newValue, this.deleted, this.format, this.additionalLocation);
    }

    public final ImmutableReplayEvent withDeleted(@Nullable Boolean value) {
        if (Objects.equals(this.deleted, value)) {
            return this;
        }
        return new ImmutableReplayEvent(this.type, this.identifier, this.payload, value, this.format, this.additionalLocation);
    }

    public final ImmutableReplayEvent withFormat(@Nullable String value) {
        if (Objects.equals(this.format, value)) {
            return this;
        }
        return new ImmutableReplayEvent(this.type, this.identifier, this.payload, this.deleted, value, this.additionalLocation);
    }

    public final ImmutableReplayEvent withAdditionalLocation(@Nullable String value) {
        if (Objects.equals(this.additionalLocation, value)) {
            return this;
        }
        return new ImmutableReplayEvent(this.type, this.identifier, this.payload, this.deleted, this.format, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplayEvent && this.equalTo((ImmutableReplayEvent)another);
    }

    private boolean equalTo(ImmutableReplayEvent another) {
        return this.type.equals(another.type) && this.identifier.equals(another.identifier) && Arrays.equals(this.payload, another.payload) && Objects.equals(this.deleted, another.deleted) && Objects.equals(this.format, another.format) && Objects.equals(this.additionalLocation, another.additionalLocation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.identifier.hashCode();
        h += (h << 5) + Arrays.hashCode(this.payload);
        h += (h << 5) + Objects.hashCode(this.deleted);
        h += (h << 5) + Objects.hashCode(this.format);
        h += (h << 5) + Objects.hashCode(this.additionalLocation);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ReplayEvent").omitNullValues().add("type", this.type).add("identifier", this.identifier).add("deleted", this.deleted).add("format", this.format).add("additionalLocation", this.additionalLocation).toString();
    }

    public static ImmutableReplayEvent copyOf(ReplayEvent instance) {
        if (instance instanceof ImmutableReplayEvent) {
            return (ImmutableReplayEvent)instance;
        }
        return ImmutableReplayEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReplayEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_IDENTIFIER = 2L;
        private long initBits = 3L;
        @Nullable
        private String type;
        @Nullable
        private Identifier identifier;
        @Nullable
        private byte[] payload;
        @Nullable
        private Boolean deleted;
        @Nullable
        private String format;
        @Nullable
        private String additionalLocation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReplayEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TypedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TypedEvent instance;
            String additionalLocationValue;
            long bits = 0L;
            if (object instanceof ReplayEvent && (additionalLocationValue = (instance = (ReplayEvent)object).additionalLocation()) != null) {
                this.additionalLocation(additionalLocationValue);
            }
            if (object instanceof EntityEvent) {
                byte[] payloadValue;
                instance = (EntityEvent)object;
                String formatValue = instance.format();
                if (formatValue != null) {
                    this.format(formatValue);
                }
                this.identifier(instance.identifier());
                Boolean deletedValue = instance.deleted();
                if (deletedValue != null) {
                    this.deleted(deletedValue);
                }
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
                if ((payloadValue = instance.payload()) != null) {
                    this.payload(payloadValue);
                }
            }
            if (object instanceof TypedEvent) {
                instance = (TypedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.type(instance.type());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="identifier")
        @CanIgnoreReturnValue
        public final Builder identifier(Identifier identifier) {
            this.identifier = ImmutableIdentifier.copyOf(identifier);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="payload")
        @CanIgnoreReturnValue
        public final Builder payload(byte ... payload) {
            this.payload = payload;
            return this;
        }

        @JsonProperty(value="deleted")
        @CanIgnoreReturnValue
        public final Builder deleted(@Nullable Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @JsonProperty(value="format")
        @CanIgnoreReturnValue
        public final Builder format(@Nullable String format) {
            this.format = format;
            return this;
        }

        @JsonProperty(value="additionalLocation")
        @CanIgnoreReturnValue
        public final Builder additionalLocation(@Nullable String additionalLocation) {
            this.additionalLocation = additionalLocation;
            return this;
        }

        public ImmutableReplayEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReplayEvent(this.type, ImmutableIdentifier.copyOf(this.identifier), this.payload, this.deleted, this.format, this.additionalLocation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("identifier");
            }
            return "Cannot build ReplayEvent, some of required attributes are not set " + attributes;
        }
    }
}

