/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.Identifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Identifier", generator="Immutables")
@Immutable
public final class ImmutableIdentifier
implements Identifier {
    private final String id;
    private final ImmutableList<String> path;
    private final transient String asPath;

    private ImmutableIdentifier(String id, ImmutableList<String> path) {
        this.id = id;
        this.path = path;
        this.asPath = Objects.requireNonNull(Identifier.super.asPath(), "asPath");
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="path")
    public ImmutableList<String> path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="asPath")
    @JsonIgnore
    public String asPath() {
        return this.asPath;
    }

    public final ImmutableIdentifier withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableIdentifier(newValue, this.path);
    }

    public final ImmutableIdentifier withPath(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableIdentifier(this.id, newValue);
    }

    public final ImmutableIdentifier withPath(Iterable<String> elements) {
        if (this.path == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableIdentifier(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentifier && this.equalTo((ImmutableIdentifier)another);
    }

    private boolean equalTo(ImmutableIdentifier another) {
        return this.id.equals(another.id) && this.path.equals(another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.path.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Identifier").omitNullValues().add("id", this.id).add("path", this.path).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIdentifier fromJson(Json json) {
        Builder builder = ImmutableIdentifier.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.path != null) {
            builder.addAllPath(json.path);
        }
        return builder.build();
    }

    public static ImmutableIdentifier copyOf(Identifier instance) {
        if (instance instanceof ImmutableIdentifier) {
            return (ImmutableIdentifier)instance;
        }
        return ImmutableIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Identifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableList.Builder<String> path = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Identifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.addAllPath(instance.path());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String element) {
            this.path.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPath(String ... elements) {
            this.path.add(elements);
            return this;
        }

        @JsonProperty(value="path")
        @CanIgnoreReturnValue
        public final Builder path(Iterable<String> elements) {
            this.path = ImmutableList.builder();
            return this.addAllPath(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPath(Iterable<String> elements) {
            this.path.addAll((Iterable)elements);
            return this;
        }

        public ImmutableIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIdentifier(this.id, (ImmutableList<String>)this.path.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Identifier, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Identifier", generator="Immutables")
    static final class Json
    implements Identifier {
        @Nullable
        String id;
        @Nullable
        List<String> path = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="path")
        public void setPath(List<String> path) {
            this.path = path;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> path() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String asPath() {
            throw new UnsupportedOperationException();
        }
    }
}

