/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.ImmutableIdentifier;
import java.util.List;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.Joiner;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableIdentifier.class)
@Value.Immutable
@Value.Style(get={"*"})
public interface Identifier
extends Comparable<Identifier> {
    public static final Joiner JOINER = Joiner.on('/').skipNulls();

    public String id();

    public List<String> path();

    public static Identifier from(String id, String ... path) {
        return ImmutableIdentifier.builder().id(id).addPath(path).build();
    }

    @Override
    default public int compareTo(Identifier identifier) {
        for (int i = 0; i < this.path().size() && i < identifier.path().size(); ++i) {
            int compared = this.path().get(i).compareTo(identifier.path().get(i));
            if (compared == 0) continue;
            return compared;
        }
        int lengthDiff = this.path().size() - identifier.path().size();
        if (lengthDiff != 0) {
            return lengthDiff;
        }
        return this.id().compareTo(identifier.id());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public String asPath() {
        if (this.path().isEmpty()) {
            return this.id();
        }
        return JOINER.join(this.path()) + "/" + this.id();
    }
}

