/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableEventFilter;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface EventFilter {
    public List<String> getEventTypes();

    public List<String> getEntityTypes();

    public List<String> getIds();

    default public boolean matches(EntityEvent event) {
        Identifier identifier = event.identifier();
        if (!(this.getEntityTypes().contains("*") || !identifier.path().isEmpty() && this.getEntityTypes().contains(identifier.path().get(0)) || Objects.equals(event.type(), "defaults") && this.getEntityTypes().contains(identifier.id()))) {
            return false;
        }
        if (!this.getIds().isEmpty() && !Objects.equals(event.type(), "defaults")) {
            String id = identifier.path().size() > 1 ? identifier.path().get(1) : identifier.id();
            return this.getIds().contains(id) || this.getIds().contains("*");
        }
        return true;
    }

    public static EventFilter fromPath(Path path) {
        if (path.getNameCount() < 2) {
            return null;
        }
        String eventType = path.getName(0).toString();
        String entityType = path.getName(1).toString();
        if (entityType.contains(".")) {
            entityType = entityType.substring(0, entityType.indexOf("."));
        }
        ImmutableEventFilter.Builder builder = ImmutableEventFilter.builder().addEventTypes(eventType).addEntityTypes(entityType);
        if (eventType.equals("defaults")) {
            builder.addIds("*");
        } else if (path.getNameCount() > 2) {
            String id = path.getName(2).toString();
            if (id.contains(".")) {
                id = id.substring(0, id.indexOf("."));
            }
            builder.addIds(id);
        }
        return builder.build();
    }

    public static EventFilter fromPaths(List<Path> paths) {
        ImmutableEventFilter.Builder builder = ImmutableEventFilter.builder();
        paths.stream().map(EventFilter::fromPath).filter(Objects::nonNull).forEach(builder::from);
        return builder.build();
    }
}

