/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.TypedEvent;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

public interface EntityEvent
extends TypedEvent,
Comparable<EntityEvent> {
    @Override
    public String type();

    public Identifier identifier();

    @Nullable
    @Value.Redacted
    public byte[] payload();

    @Nullable
    public Boolean deleted();

    @Nullable
    public String format();

    @Override
    default public int compareTo(EntityEvent event) {
        int typeCompared = this.type().compareTo(event.type());
        if (typeCompared != 0) {
            return typeCompared;
        }
        return this.identifier().compareTo(event.identifier());
    }

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public String asPath() {
        return String.format("%s/%s.%s", this.type(), this.identifier().asPath(), this.format());
    }
}

