/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.domain.AbstractKeyValueStore;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.MergeableKeyValueStore;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMergeableKeyValueStore<T>
extends AbstractKeyValueStore<T>
implements MergeableKeyValueStore<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMergeableKeyValueStore.class);

    protected abstract ValueEncoding<T> getValueEncoding();

    protected boolean isUpdateValid(Identifier identifier, byte[] payload) {
        try {
            return this.getEventSourcing().isInCache(identifier) && Objects.nonNull(this.getValueEncoding().deserialize(identifier, payload, this.getValueEncoding().getDefaultFormat(), false));
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public CompletableFuture<T> patch(String id, Map<String, Object> partialData, String ... path) {
        byte[] payload;
        Identifier identifier = Identifier.from(id, path);
        if (!this.isUpdateValid(identifier, payload = this.getValueEncoding().serialize(this.modifyPatch(partialData)))) {
            throw new IllegalArgumentException("Partial update for ... not valid");
        }
        try {
            byte[] merged = this.getValueEncoding().serialize(this.getValueEncoding().deserialize(identifier, payload, this.getValueEncoding().getDefaultFormat(), false));
            return this.getEventSourcing().pushMutationEventRaw(identifier, merged).whenComplete((entityData, throwable) -> {
                if (Objects.nonNull(entityData)) {
                    this.onUpdate(identifier, entityData);
                } else if (Objects.nonNull(throwable)) {
                    this.onFailure(identifier, (Throwable)throwable);
                }
            });
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    protected Map<String, Object> modifyPatch(Map<String, Object> partialData) {
        return partialData;
    }
}

