/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.domain;

import de.ii.xtraplatform.store.app.EventSourcing;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.KeyValueStore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyValueStore<T>
implements KeyValueStore<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKeyValueStore.class);

    protected abstract EventSourcing<T> getEventSourcing();

    protected CompletableFuture<Void> onStart() {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onCreate(Identifier identifier, T entityData) {
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onUpdate(Identifier identifier, T entityData) {
        return CompletableFuture.completedFuture(null);
    }

    protected void onDelete(Identifier identifier) {
    }

    protected void onFailure(Identifier identifier, Throwable throwable) {
    }

    @Override
    public List<String> ids(String ... path) {
        return this.identifiers(path).stream().map(Identifier::id).collect(Collectors.toList());
    }

    @Override
    public boolean has(String id, String ... path) {
        return Objects.nonNull(id) && this.has(Identifier.from(id, path));
    }

    @Override
    public T get(String id, String ... path) {
        return this.get(Identifier.from(id, path));
    }

    @Override
    public CompletableFuture<T> put(String id, T value, String ... path) {
        return this.put(Identifier.from(id, path), value);
    }

    @Override
    public CompletableFuture<Boolean> delete(String id, String ... path) {
        return this.drop(Identifier.from(id, path));
    }

    @Override
    public List<Identifier> identifiers(String ... path) {
        return this.getEventSourcing().getIdentifiers(path);
    }

    @Override
    public boolean has(Identifier identifier) {
        return this.getEventSourcing().isInCache(identifier);
    }

    @Override
    public T get(Identifier identifier) {
        return this.getEventSourcing().getFromCache(identifier);
    }

    @Override
    public CompletableFuture<T> put(Identifier identifier, T value) {
        boolean exists = this.has(identifier);
        return this.getEventSourcing().pushMutationEvent(identifier, value).whenComplete((entityData, throwable) -> {
            if (Objects.nonNull(throwable)) {
                this.onFailure(identifier, (Throwable)throwable);
            } else if (Objects.nonNull(entityData)) {
                if (exists) {
                    this.onUpdate(identifier, entityData);
                } else {
                    this.onCreate(identifier, entityData).join();
                }
            }
        });
    }

    protected CompletableFuture<T> putWithoutTrigger(Identifier identifier, T value) {
        return this.getEventSourcing().pushMutationEvent(identifier, value);
    }

    protected CompletableFuture<T> putPartialWithoutTrigger(Identifier identifier, Map<String, Object> value) {
        return this.getEventSourcing().pushPartialMutationEvent(identifier, value);
    }

    protected CompletableFuture<Boolean> drop(Identifier identifier) {
        return ((CompletableFuture)this.getEventSourcing().pushMutationEvent(identifier, null).whenComplete((entityData, throwable) -> {
            if (Objects.nonNull(throwable)) {
                this.onFailure(identifier, (Throwable)throwable);
            } else if (Objects.isNull(entityData)) {
                this.onDelete(identifier);
            }
        })).thenApply(Objects::isNull);
    }

    protected CompletableFuture<Boolean> dropWithoutTrigger(Identifier identifier) {
        return this.getEventSourcing().pushMutationEvent(identifier, null).thenApply(Objects::isNull);
    }
}

