/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app.entities;

import de.ii.xtraplatform.store.app.EventSourcing;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ValueDecoderMiddleware;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import java.io.IOException;
import java.util.function.BiFunction;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;

public class ValueDecoderEntitySubtype
implements ValueDecoderMiddleware<EntityData> {
    private final BiFunction<Identifier, String, EntityDataBuilder<EntityData>> newBuilderSupplier;
    private final EventSourcing<EntityData> eventSourcing;

    public ValueDecoderEntitySubtype(BiFunction<Identifier, String, EntityDataBuilder<EntityData>> newBuilderSupplier, EventSourcing<EntityData> eventSourcing) {
        this.newBuilderSupplier = newBuilderSupplier;
        this.eventSourcing = eventSourcing;
    }

    @Override
    public EntityData process(Identifier identifier, byte[] payload, ObjectMapper objectMapper, EntityData data, boolean ignoreCache) throws IOException {
        if (data.getEntitySubType().isPresent()) {
            EntityDataBuilder<EntityData> builder = this.newBuilderSupplier.apply(identifier, data.getEntitySubType().get());
            if (builder == null) {
                return data;
            }
            if (this.eventSourcing.isInCache(identifier) && !ignoreCache) {
                builder.from(this.eventSourcing.getFromCache(identifier));
            }
            objectMapper.readerForUpdating(builder).readValue(payload);
            return builder.build();
        }
        return data;
    }
}

