/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app.entities;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Lists;
import shadow.com.google.common.collect.MapDifference;
import shadow.com.google.common.collect.Maps;

public class MapSubtractor {
    public Map<String, Object> subtract(Map<String, Object> data, Map<String, Object> defaults, List<String> ignoreKeys) {
        if (Objects.equals(data, defaults)) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        MapDifference<String, Object> difference = Maps.difference(data, defaults);
        Map<String, Object> newEntries = difference.entriesOnlyOnLeft();
        Map<String, MapDifference.ValueDifference<Object>> differingEntries = difference.entriesDiffering();
        for (String key : data.keySet()) {
            if (ignoreKeys.contains(key)) {
                result.put(key, data.get(key));
            }
            if (newEntries.containsKey(key)) {
                result.put(key, newEntries.get(key));
            }
            if (!differingEntries.containsKey(key)) continue;
            MapDifference.ValueDifference<Object> diff = differingEntries.get(key);
            if (diff.leftValue() instanceof Map) {
                result.put(key, this.subtract((Map)diff.leftValue(), (Map)diff.rightValue(), ignoreKeys));
                continue;
            }
            if (diff.leftValue() instanceof Collection) {
                result.put(key, this.subtract((Collection)diff.leftValue(), (Collection)diff.rightValue()));
                continue;
            }
            result.put(key, diff.leftValue());
        }
        return result;
    }

    private Collection<Object> subtract(Collection<Object> left, Collection<Object> right) {
        ArrayList<Object> diff = Lists.newArrayList(left);
        for (Object item : right) {
            Optional<Object> leftMatch;
            boolean removed = diff.remove(item);
            if (removed || !(item instanceof Map) || !((Map)item).containsKey("buildingBlock") || !(leftMatch = left.stream().filter(leftItem -> leftItem instanceof Map && ((Map)leftItem).containsKey("buildingBlock") && Objects.equals(((Map)leftItem).get("buildingBlock"), ((Map)item).get("buildingBlock"))).findFirst()).isPresent()) continue;
            Map<String, Object> subtracted = this.subtract((Map)leftMatch.get(), (Map)item, ImmutableList.of("buildingBlock"));
            diff.set(diff.indexOf(leftMatch.get()), subtracted);
        }
        return diff;
    }

    private Map<String, Object> entriesDiffering(MapDifference<String, Object> difference) {
        return difference.entriesDiffering().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).rightValue())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean containsMaps(Collection<?> collection) {
        return !collection.isEmpty() && collection.iterator().next() instanceof Map;
    }
}

