/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app.entities;

import dagger.Lazy;
import de.ii.xtraplatform.base.domain.AppContext;
import de.ii.xtraplatform.base.domain.Jackson;
import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.store.app.EventSourcing;
import de.ii.xtraplatform.store.app.ValueDecoderBase;
import de.ii.xtraplatform.store.app.ValueDecoderEnvVarSubstitution;
import de.ii.xtraplatform.store.app.ValueDecoderWithBuilder;
import de.ii.xtraplatform.store.app.ValueEncodingJackson;
import de.ii.xtraplatform.store.app.entities.ValueDecoderEntitySubtype;
import de.ii.xtraplatform.store.app.entities.ValueDecoderIdValidator;
import de.ii.xtraplatform.store.domain.AbstractMergeableKeyValueStore;
import de.ii.xtraplatform.store.domain.EventStore;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableIdentifier;
import de.ii.xtraplatform.store.domain.ImmutableReplayEvent;
import de.ii.xtraplatform.store.domain.KeyPathAlias;
import de.ii.xtraplatform.store.domain.KeyPathAliasUnwrap;
import de.ii.xtraplatform.store.domain.ReplayEvent;
import de.ii.xtraplatform.store.domain.ValueCache;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.EntityDataDefaultsStore;
import de.ii.xtraplatform.store.domain.entities.EntityDataOverridesPath;
import de.ii.xtraplatform.store.domain.entities.EntityDataStore;
import de.ii.xtraplatform.store.domain.entities.EntityFactories;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import de.ii.xtraplatform.store.domain.entities.EntityStoreDecorator;
import de.ii.xtraplatform.streams.domain.Event;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Maps;
import shadow.com.google.common.collect.ObjectArrays;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind(interfaces={EntityDataStore.class})
public class EntityDataStoreImpl
extends AbstractMergeableKeyValueStore<EntityData>
implements EntityDataStore<EntityData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityDataStoreImpl.class);
    private static final List<String> EVENT_TYPES = ImmutableList.of("entities", "overrides");
    private final boolean isEventStoreReadOnly;
    private final EntityFactories entityFactories;
    private final Queue<Map.Entry<Identifier, EntityData>> additionalEvents;
    private final ValueEncodingJackson<EntityData> valueEncoding;
    private final ValueEncodingJackson<Map<String, Object>> valueEncodingMap;
    private final EventSourcing<EntityData> eventSourcing;
    private final EntityDataDefaultsStore defaultsStore;
    private static Map<String, KeyPathAliasUnwrap> reverseAliases = ImmutableMap.of("api", value -> ((List)value).stream().map(buildingBlock -> new AbstractMap.SimpleImmutableEntry<String, Map>(((String)buildingBlock.get("buildingBlock")).toLowerCase(), (Map)buildingBlock)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));

    @Inject
    public EntityDataStoreImpl(AppContext appContext, EventStore eventStore, Jackson jackson, Lazy<Set<EntityFactory>> entityFactories, EntityDataDefaultsStore defaultsStore) {
        this.isEventStoreReadOnly = eventStore.isReadOnly();
        this.entityFactories = new EntityFactories(entityFactories);
        this.additionalEvents = new ConcurrentLinkedQueue<Map.Entry<Identifier, EntityData>>();
        this.valueEncoding = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.valueEncodingMap = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.eventSourcing = new EventSourcing<EntityData>(eventStore, EVENT_TYPES, this.valueEncoding, this::onStart, Optional.of(this::processEvent), Optional.empty(), Optional.of(this::onUpdate));
        this.defaultsStore = defaultsStore;
        this.valueEncoding.addDecoderPreProcessor(new ValueDecoderEnvVarSubstitution());
        this.valueEncoding.addDecoderMiddleware(new ValueDecoderWithBuilder<EntityData>(this::getBuilder, this.eventSourcing));
        this.valueEncoding.addDecoderMiddleware(new ValueDecoderEntitySubtype(this::getBuilder, this.eventSourcing));
        this.valueEncoding.addDecoderMiddleware(new ValueDecoderIdValidator());
        this.eventSourcing.start();
        this.valueEncodingMap.addDecoderMiddleware(new ValueDecoderBase<Map<String, Object>>(identifier -> new LinkedHashMap(), new ValueCache<Map<String, Object>>(){

            @Override
            public boolean isInCache(Identifier identifier) {
                return false;
            }

            @Override
            public Map<String, Object> getFromCache(Identifier identifier) {
                return null;
            }
        }));
    }

    @Override
    public ValueEncoding<EntityData> getValueEncoding() {
        return this.valueEncoding;
    }

    @Override
    protected EventSourcing<EntityData> getEventSourcing() {
        return this.eventSourcing;
    }

    @Override
    protected Map<String, Object> modifyPatch(Map<String, Object> partialData) {
        if (Objects.nonNull(partialData) && !partialData.isEmpty()) {
            HashMap<String, Object> modified = Maps.newHashMap(partialData);
            modified.put("lastModified", Instant.now().toEpochMilli());
            return modified;
        }
        return partialData;
    }

    private List<ReplayEvent> processEvent(ReplayEvent event) {
        if (this.valueEncoding.isEmpty(event.payload()) || !this.valueEncoding.isSupported(event.format())) {
            return ImmutableList.of();
        }
        if (Objects.nonNull(event.additionalLocation()) && event.type().equals(EVENT_TYPES.get(0))) {
            LOGGER.warn("Ignoring entity '{}' in '{}', entities are not allowed in additionalLocations", (Object)event.asPath(), (Object)event.additionalLocation());
            return ImmutableList.of();
        }
        if (!event.type().equals(EVENT_TYPES.get(1))) {
            return ImmutableList.of(event);
        }
        EntityDataOverridesPath overridesPath = EntityDataOverridesPath.from(event.identifier());
        ImmutableIdentifier cacheKey = ImmutableIdentifier.builder().addPath(overridesPath.getEntityType()).id(overridesPath.getEntityId()).build();
        if (!this.eventSourcing.isInCache(cacheKey)) {
            LOGGER.warn("Ignoring override '{}', no matching entity found", (Object)event.asPath());
            return ImmutableList.of();
        }
        ImmutableReplayEvent.Builder builder = ImmutableReplayEvent.builder().from(event).identifier(cacheKey);
        if (!overridesPath.getKeyPath().isEmpty()) {
            Optional<KeyPathAlias> keyPathAlias = this.entityFactories.get(overridesPath.getEntityType()).getKeyPathAlias(overridesPath.getKeyPath().get(overridesPath.getKeyPath().size() - 1));
            try {
                byte[] nestedPayload = this.valueEncoding.nestPayload(event.payload(), event.format(), overridesPath.getKeyPath(), keyPathAlias);
                builder.payload(nestedPayload);
            }
            catch (IOException e) {
                LogContext.error(LOGGER, e, "Deserialization error", new Object[0]);
            }
        }
        return ImmutableList.of(builder.build());
    }

    protected EntityDataBuilder<EntityData> getBuilder(Identifier identifier) {
        return this.entityFactories.get(identifier.path().get(0)).dataBuilder();
    }

    protected EntityDataBuilder<EntityData> getBuilder(Identifier identifier, String entitySubtype) {
        ImmutableIdentifier defaultsIdentifier = ImmutableIdentifier.builder().from(identifier).id("defaults").addPath(entitySubtype.toLowerCase()).build();
        if (this.defaultsStore.has(defaultsIdentifier)) {
            return this.defaultsStore.getBuilder(defaultsIdentifier);
        }
        return this.entityFactories.get(identifier.path().get(0), entitySubtype).dataBuilder();
    }

    protected EntityData hydrate(Identifier identifier, EntityData entityData) {
        String entityType = identifier.path().get(0);
        return this.entityFactories.get(entityType, entityData.getEntitySubType()).hydrateData(entityData);
    }

    protected void addAdditionalEvent(Identifier identifier, EntityData entityData) {
        this.additionalEvents.add(new AbstractMap.SimpleImmutableEntry<Identifier, EntityData>(identifier, entityData));
    }

    @Override
    protected CompletableFuture<Void> onStart() {
        return ((CompletableFuture)((CompletableFuture)this.playAdditionalEvents().thenCompose(ignore -> {
            if (!this.additionalEvents.isEmpty()) {
                return this.playAdditionalEvents();
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(ignore -> this.identifiers(new String[0]).stream().sorted(Comparator.comparing(identifier -> identifier.path().get(0))).reduce(CompletableFuture.completedFuture(null), (completableFuture, identifier) -> completableFuture.thenCompose(ignore2 -> this.onCreate((Identifier)identifier, (EntityData)this.get((Identifier)identifier))), (first, second) -> first.thenCompose(ignore2 -> second)))).thenCompose(entity -> CompletableFuture.completedFuture(null));
    }

    private CompletableFuture<EntityData> playAdditionalEvents() {
        CompletionStage<Object> completableFuture = CompletableFuture.completedFuture(null);
        while (!this.additionalEvents.isEmpty()) {
            Map.Entry<Identifier, EntityData> entry = this.additionalEvents.remove();
            completableFuture = completableFuture.thenCompose(ignore -> {
                if (this.isEventStoreReadOnly) {
                    this.getEventSourcing().onEmit((Event)ImmutableReplayEvent.builder().type(EVENT_TYPES.get(0)).identifier((Identifier)entry.getKey()).payload(this.valueEncoding.serialize((EntityData)entry.getValue())).format(this.valueEncoding.getDefaultFormat().toString()).build());
                    return CompletableFuture.completedFuture(null);
                }
                return this.dropWithoutTrigger((Identifier)entry.getKey()).thenCompose(deleted -> this.putWithoutTrigger((Identifier)entry.getKey(), (EntityData)entry.getValue()));
            });
        }
        return completableFuture;
    }

    @Override
    protected CompletableFuture<Void> onCreate(Identifier identifier, EntityData entityData) {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, identifier.id());){
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Entity creating: {}", (Object)identifier);
            }
            try {
                EntityData hydratedData = this.hydrateData(identifier, entityData);
                CompletionStage completionStage = ((CompletableFuture)this.entityFactories.get(identifier.path().get(0)).createInstance(hydratedData).whenComplete((entity, throwable) -> {
                    if (Objects.nonNull(entity) && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Entity created: {}", (Object)identifier);
                    }
                })).thenAccept(ignore -> CompletableFuture.completedFuture(null));
                return completionStage;
            }
            catch (Throwable e) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                if (closeable != null) {
                    closeable.close();
                }
                return completableFuture;
            }
        }
    }

    @Override
    protected CompletableFuture<Void> onUpdate(Identifier identifier, EntityData entityData) {
        try (MDC.MDCCloseable closeable = LogContext.putCloseable(LogContext.CONTEXT.SERVICE, identifier.id());){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reloading entity: {}", (Object)identifier);
            }
            EntityData hydratedData = this.hydrateData(identifier, entityData);
            CompletionStage completionStage = this.entityFactories.get(identifier.path().get(0)).updateInstance(hydratedData).thenAccept(ignore -> CompletableFuture.completedFuture(null));
            return completionStage;
        }
    }

    @Override
    protected void onDelete(Identifier identifier) {
        this.entityFactories.get(identifier.path().get(0)).deleteInstance(identifier.id());
    }

    @Override
    protected void onFailure(Identifier identifier, Throwable throwable) {
        LogContext.error(LOGGER, throwable, "Could not save entity with id '{}'", identifier);
    }

    @Override
    public <U extends EntityData> EntityDataStore<U> forType(Class<U> type) {
        final String entityType = this.entityFactories.get(type).type();
        return new EntityStoreDecorator<EntityData, U>(){

            @Override
            public EntityDataStore<EntityData> getDecorated() {
                return EntityDataStoreImpl.this;
            }

            @Override
            public String[] transformPath(String ... path) {
                return ObjectArrays.concat(entityType, path);
            }
        };
    }

    @Override
    public Map<String, Object> asMap(Identifier identifier, EntityData entityData) throws IOException {
        return this.valueEncodingMap.deserialize(identifier, this.valueEncoding.serialize(entityData), this.valueEncoding.getDefaultFormat(), false);
    }

    @Override
    public EntityData fromMap(Identifier identifier, Map<String, Object> entityData) throws IOException {
        return this.valueEncoding.deserialize(identifier, this.valueEncoding.serialize(entityData), this.valueEncoding.getDefaultFormat(), false);
    }

    @Override
    public EntityData fromBytes(Identifier identifier, byte[] entityData) throws IOException {
        return this.valueEncoding.deserialize(identifier, entityData, this.valueEncoding.getDefaultFormat(), true);
    }

    @Override
    public CompletableFuture<EntityData> put(String id, EntityData data, String ... path) {
        Identifier identifier = Identifier.from(id, path);
        try {
            Map<String, Object> map = this.asMap(identifier, data);
            Map<String, Object> withoutDefaults = this.defaultsStore.subtractDefaults(identifier, data.getEntitySubType(), map, ImmutableList.of());
            return this.getEventSourcing().pushPartialMutationEvent(identifier, withoutDefaults).whenComplete((entityData, throwable) -> {
                if (Objects.nonNull(entityData)) {
                    this.onCreate(identifier, (EntityData)entityData).join();
                } else if (Objects.nonNull(throwable)) {
                    this.onFailure(identifier, (Throwable)throwable);
                }
            });
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<EntityData> patch(String id, Map<String, Object> partialData, String ... path) {
        return this.patch(id, partialData, false, path);
    }

    @Override
    public CompletableFuture<EntityData> patch(String id, Map<String, Object> partialData, boolean skipLastModified, String ... path) {
        Identifier identifier = Identifier.from(id, path);
        Map<String, Object> patch = skipLastModified ? partialData : this.modifyPatch(partialData);
        byte[] payload = this.getValueEncoding().serialize(patch);
        if (!this.isUpdateValid(identifier, payload)) {
            throw new IllegalArgumentException("Partial update for ... not valid");
        }
        try {
            EntityData merged = this.getValueEncoding().deserialize(identifier, payload, this.getValueEncoding().getDefaultFormat(), false);
            Map<String, Object> map = this.asMap(identifier, merged);
            Map<String, Object> withoutDefaults = this.defaultsStore.subtractDefaults(identifier, merged.getEntitySubType(), map, ImmutableList.of("enabled"));
            Map<String, Object> withoutResetted = this.subtractResetted(withoutDefaults, partialData, this.entityFactories.get(identifier.path().get(0), merged.getEntitySubType()));
            return this.getEventSourcing().pushPartialMutationEvent(identifier, withoutResetted).whenComplete((entityData, throwable) -> {
                if (Objects.nonNull(entityData)) {
                    this.onUpdate(identifier, (EntityData)entityData).join();
                } else if (Objects.nonNull(throwable)) {
                    this.onFailure(identifier, (Throwable)throwable);
                }
            });
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Map<String, Object> subtractResetted(Map<String, Object> source, Map<String, Object> potentialNulls, EntityFactory entityFactory) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        source.forEach((key, value) -> {
            if (potentialNulls.containsKey(key) && Objects.isNull(potentialNulls.get(key))) {
                return;
            }
            Map<String, Object> newValue = value instanceof Map && potentialNulls.get(key) instanceof Map ? this.subtractResetted((Map<String, Object>)value, (Map)potentialNulls.get(key), entityFactory) : (value instanceof List && potentialNulls.get(key) instanceof List ? this.subtractResetted((List)((Object)value), (List)potentialNulls.get(key), entityFactory, (String)key) : (value instanceof List && potentialNulls.get(key) instanceof Map ? this.subtractResetted((List)((Object)value), (Map)potentialNulls.get(key)) : value));
            result.put((String)key, newValue);
        });
        return result;
    }

    private List<Object> subtractResetted(List<Object> source, List<Object> potentialNulls, EntityFactory entityFactory, String parentKey) {
        if (!reverseAliases.containsKey(parentKey)) {
            return source;
        }
        ArrayList result = new ArrayList();
        KeyPathAliasUnwrap aliasUnwrap = reverseAliases.get(parentKey);
        Map<String, Object> resetted = this.subtractResetted(aliasUnwrap.wrapMap(source), aliasUnwrap.wrapMap(potentialNulls), entityFactory);
        resetted.forEach((s, o) -> ((Map)o).remove("buildingBlock"));
        List<Object> collect = resetted.entrySet().stream().flatMap(entry -> entityFactory.getKeyPathAlias((String)entry.getKey()).map(keyPathAlias1 -> keyPathAlias1.wrapMap((Map)entry.getValue()).values().stream().flatMap(coll -> ((List)coll).stream())).orElse(Stream.empty())).collect(Collectors.toList());
        return collect;
    }

    private List<Object> subtractResetted(List<Object> source, Map<String, Object> potentialNulls) {
        ArrayList<Object> result = new ArrayList<Object>();
        source.forEach(item -> {
            if (potentialNulls.containsKey(item) && Objects.isNull(potentialNulls.get(item))) {
                return;
            }
            result.add(item);
        });
        return result;
    }

    private EntityData hydrateData(Identifier identifier, EntityData entityData) {
        AutoEntity autoEntity;
        EntityData hydratedData = entityData;
        if (entityData instanceof AutoEntity && (autoEntity = (AutoEntity)((Object)entityData)).isAuto() && autoEntity.isAutoPersist()) {
            hydratedData = this.hydrate(identifier, hydratedData);
            if (!this.isEventStoreReadOnly) {
                try {
                    Map<String, Object> map = this.asMap(identifier, hydratedData);
                    Map<String, Object> withoutDefaults = this.defaultsStore.subtractDefaults(identifier, entityData.getEntitySubType(), map, ImmutableList.of());
                    this.putPartialWithoutTrigger(identifier, withoutDefaults).join();
                    LOGGER.info("Entity of type '{}' with id '{}' is in autoPersist mode, generated configuration was saved.", (Object)identifier.path().get(0), (Object)entityData.getId());
                }
                catch (IOException e) {
                    LogContext.error(LOGGER, e, "Entity of type '{}' with id '{}' is in autoPersist mode, but generated configuration could not be saved", identifier.path().get(0), entityData.getId());
                }
            } else {
                LOGGER.warn("Entity of type '{}' with id '{}' is in autoPersist mode, but was not persisted because the store is read only.", (Object)identifier.path().get(0), (Object)entityData.getId());
            }
        }
        hydratedData = this.hydrate(identifier, hydratedData);
        return hydratedData;
    }
}

