/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app.entities;

import dagger.Lazy;
import de.ii.xtraplatform.base.domain.AppContext;
import de.ii.xtraplatform.base.domain.Jackson;
import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.base.domain.util.LambdaWithException;
import de.ii.xtraplatform.store.app.EventSourcing;
import de.ii.xtraplatform.store.app.ValueDecoderBase;
import de.ii.xtraplatform.store.app.ValueDecoderEnvVarSubstitution;
import de.ii.xtraplatform.store.app.ValueDecoderWithBuilder;
import de.ii.xtraplatform.store.app.ValueEncodingJackson;
import de.ii.xtraplatform.store.app.entities.MapSubtractor;
import de.ii.xtraplatform.store.domain.AbstractMergeableKeyValueStore;
import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.EventFilter;
import de.ii.xtraplatform.store.domain.EventStore;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableIdentifier;
import de.ii.xtraplatform.store.domain.ImmutableMutationEvent;
import de.ii.xtraplatform.store.domain.ImmutableReplayEvent;
import de.ii.xtraplatform.store.domain.KeyPathAlias;
import de.ii.xtraplatform.store.domain.MergeableKeyValueStore;
import de.ii.xtraplatform.store.domain.MutationEvent;
import de.ii.xtraplatform.store.domain.ReplayEvent;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.ValueCache;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.EntityDataDefaultsPath;
import de.ii.xtraplatform.store.domain.entities.EntityDataDefaultsStore;
import de.ii.xtraplatform.store.domain.entities.EntityFactories;
import de.ii.xtraplatform.store.domain.entities.EntityFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind(interfaces={EntityDataDefaultsStore.class})
public class EntityDataDefaultsStoreImpl
extends AbstractMergeableKeyValueStore<Map<String, Object>>
implements EntityDataDefaultsStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityDataDefaultsStoreImpl.class);
    private final EntityFactories entityFactories;
    private final ValueEncodingJackson<Map<String, Object>> valueEncoding;
    private final ValueEncodingJackson<EntityDataBuilder<EntityData>> valueEncodingBuilder;
    private final ValueEncodingJackson<Map<String, Object>> valueEncodingMap;
    private final ValueEncodingJackson<EntityData> valueEncodingEntity;
    private final EventSourcing<Map<String, Object>> eventSourcing;
    private final EventStore eventStore;

    @Inject
    public EntityDataDefaultsStoreImpl(AppContext appContext, EventStore eventStore, Jackson jackson, Lazy<Set<EntityFactory>> entityFactories) {
        this.entityFactories = new EntityFactories(entityFactories);
        this.eventStore = eventStore;
        this.valueEncoding = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.eventSourcing = new EventSourcing<Map<String, Object>>(eventStore, ImmutableList.of("defaults"), this.valueEncoding, this::onStart, Optional.of(this::processReplayEvent), Optional.of(this::processMutationEvent), Optional.empty(), Optional.of(LambdaWithException.biConsumerMayThrow(this::validateDefaults)));
        this.valueEncoding.addDecoderPreProcessor(new ValueDecoderEnvVarSubstitution());
        this.valueEncoding.addDecoderMiddleware(new ValueDecoderBase<Map<String, Object>>(this::getDefaults, this.eventSourcing));
        this.eventSourcing.start();
        this.valueEncodingBuilder = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.valueEncodingBuilder.addDecoderMiddleware(new ValueDecoderBase<EntityDataBuilder<EntityData>>(this::getNewBuilder, new ValueCache<EntityDataBuilder<EntityData>>(){

            @Override
            public boolean isInCache(Identifier identifier) {
                return false;
            }

            @Override
            public EntityDataBuilder<EntityData> getFromCache(Identifier identifier) {
                return null;
            }
        }));
        this.valueEncodingMap = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.valueEncodingMap.addDecoderMiddleware(new ValueDecoderBase<Map<String, Object>>(identifier -> new LinkedHashMap(), new ValueCache<Map<String, Object>>(){

            @Override
            public boolean isInCache(Identifier identifier) {
                return false;
            }

            @Override
            public Map<String, Object> getFromCache(Identifier identifier) {
                return null;
            }
        }));
        this.valueEncodingEntity = new ValueEncodingJackson(jackson, appContext.getConfiguration().store.failOnUnknownProperties);
        this.valueEncodingEntity.addDecoderMiddleware(new ValueDecoderWithBuilder<EntityData>(this::getBuilder, new ValueCache<EntityData>(){

            @Override
            public boolean isInCache(Identifier identifier) {
                return false;
            }

            @Override
            public EntityData getFromCache(Identifier identifier) {
                return null;
            }
        }));
    }

    private List<ReplayEvent> processReplayEvent(ReplayEvent event) {
        return this.processEvent(event).map(entityEvent -> (ReplayEvent)entityEvent).collect(Collectors.toList());
    }

    private List<MutationEvent> processMutationEvent(MutationEvent event) {
        return this.processEvent(event).map(entityEvent -> ImmutableMutationEvent.builder().from((EntityEvent)entityEvent).build()).collect(Collectors.toList());
    }

    private Stream<EntityEvent> processEvent(EntityEvent event) {
        if (this.valueEncoding.isEmpty(event.payload()) || !this.valueEncoding.isSupported(event.format())) {
            return Stream.empty();
        }
        EntityDataDefaultsPath defaultsPath = EntityDataDefaultsPath.from(event.identifier());
        List<String> subTypes = this.entityFactories.getSubTypes(defaultsPath.getEntityType(), defaultsPath.getEntitySubtype());
        List<Identifier> cacheKeys = this.getCacheKeys(defaultsPath, subTypes);
        return cacheKeys.stream().map(cacheKey -> {
            ImmutableReplayEvent.Builder builder = ImmutableReplayEvent.builder().from(event).identifier((Identifier)cacheKey);
            if (!defaultsPath.getKeyPath().isEmpty() && !Objects.equals(defaultsPath.getKeyPath().get(0), "defaults")) {
                Optional<KeyPathAlias> keyPathAlias = this.entityFactories.get(cacheKey.path().get(0), cacheKey.path().get(1)).getKeyPathAlias(defaultsPath.getKeyPath().get(defaultsPath.getKeyPath().size() - 1));
                try {
                    byte[] nestedPayload = this.valueEncoding.nestPayload(event.payload(), event.format(), defaultsPath.getKeyPath(), keyPathAlias);
                    builder.payload(nestedPayload);
                }
                catch (IOException e) {
                    LogContext.error(LOGGER, e, "Deserialization error", new Object[0]);
                }
            }
            return builder.build();
        });
    }

    private List<Identifier> getCacheKeys(EntityDataDefaultsPath defaultsPath, List<String> subTypes) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(ImmutableIdentifier.builder().addPath(defaultsPath.getEntityType()).addAllPath(defaultsPath.getEntitySubtype()).id("defaults").build())).addAll((Iterable)subTypes.stream().map(subType -> ImmutableIdentifier.builder().addPath(defaultsPath.getEntityType()).addPath((String)subType).id("defaults").build()).collect(Collectors.toList()))).build();
    }

    @Override
    public Map<String, Object> subtractDefaults(Identifier identifier, Optional<String> subType, Map<String, Object> data, List<String> ignoreKeys) {
        ImmutableIdentifier defaultsIdentifier = subType.isPresent() ? ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).addPath(subType.get().toLowerCase()).build() : ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).build();
        EntityDataBuilder<EntityData> newBuilder = this.getBuilder(defaultsIdentifier).fillRequiredFieldsWithPlaceholders();
        try {
            byte[] payload = this.valueEncodingEntity.serialize((EntityData)newBuilder.build());
            Map<String, Object> defaults = this.valueEncodingMap.deserialize(defaultsIdentifier, payload, this.valueEncodingBuilder.getDefaultFormat(), false);
            return new MapSubtractor().subtract(data, defaults, ignoreKeys);
        }
        catch (Throwable e) {
            boolean bl = true;
            return data;
        }
    }

    @Override
    public Map<String, Object> asMap(Identifier identifier, EntityData entityData) throws IOException {
        Optional<String> subType = entityData.getEntitySubType();
        ImmutableIdentifier defaultsIdentifier = subType.isPresent() ? ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).addPath(subType.get().toLowerCase()).build() : ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).build();
        return this.valueEncodingMap.deserialize(defaultsIdentifier, this.valueEncodingEntity.serialize(entityData), this.valueEncoding.getDefaultFormat(), false);
    }

    @Override
    public Optional<Map<String, Object>> getAllDefaults(Identifier identifier, Optional<String> subType) {
        ImmutableIdentifier defaultsIdentifier = subType.isPresent() ? ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).addPath(subType.get().toLowerCase()).build() : ImmutableIdentifier.builder().id("defaults").addAllPath(identifier.path()).build();
        Optional<EntityDataBuilder<EntityData>> newBuilder = Optional.ofNullable(this.getBuilder(defaultsIdentifier).fillRequiredFieldsWithPlaceholders());
        if (newBuilder.isPresent()) {
            try {
                Value data = newBuilder.get().build();
                byte[] payload = this.valueEncodingEntity.serialize((EntityData)data);
                Map defaults = this.valueEncodingMap.deserialize(defaultsIdentifier, payload, this.valueEncodingBuilder.getDefaultFormat(), false);
                defaults = defaults.entrySet().stream().filter(entry -> !Objects.equals(entry.getValue(), "__DEFAULT__")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                return Optional.ofNullable(defaults);
            }
            catch (Throwable e) {
                boolean bl = true;
            }
        }
        return Optional.empty();
    }

    private Map<String, Object> getDefaults(Identifier identifier) {
        if (this.eventSourcing.isInCache(identifier)) {
            return this.eventSourcing.getFromCache(identifier);
        }
        return new LinkedHashMap<String, Object>();
    }

    public EntityDataBuilder<EntityData> getNewBuilder(Identifier identifier) {
        EntityDataDefaultsPath defaultsPath = EntityDataDefaultsPath.from(identifier);
        Optional<String> subtype = this.entityFactories.getTypeAsString(defaultsPath.getEntitySubtype());
        return this.entityFactories.get(defaultsPath.getEntityType(), subtype).dataBuilder();
    }

    @Override
    public EntityDataBuilder<EntityData> getBuilder(Identifier identifier) {
        if (this.eventSourcing.isInCache(identifier)) {
            Map<String, Object> defaults = this.eventSourcing.getFromCache(identifier);
            byte[] payload = this.valueEncodingBuilder.serialize(defaults);
            try {
                return this.valueEncodingBuilder.deserialize(identifier, payload, this.valueEncodingBuilder.getDefaultFormat(), false);
            }
            catch (IOException e) {
                LogContext.error(LOGGER, e, "Cannot load defaults for '{}'", identifier.asPath());
            }
        }
        return this.getNewBuilder(identifier);
    }

    private void validateDefaults(Identifier identifier, Map<String, Object> defaults) throws IOException {
        byte[] payload = this.valueEncodingBuilder.serialize(defaults);
        this.valueEncodingBuilder.deserialize(identifier, payload, this.valueEncodingBuilder.getDefaultFormat(), false);
    }

    @Override
    protected ValueEncoding<Map<String, Object>> getValueEncoding() {
        return this.valueEncoding;
    }

    @Override
    protected EventSourcing<Map<String, Object>> getEventSourcing() {
        return this.eventSourcing;
    }

    @Override
    public <U extends Map<String, Object>> MergeableKeyValueStore<U> forType(Class<U> type) {
        return null;
    }

    @Override
    protected CompletableFuture<Void> onStart() {
        this.identifiers(new String[0]).forEach(identifier -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded defaults: {}", identifier);
            }
        });
        return super.onStart();
    }

    @Override
    public CompletableFuture<Map<String, Object>> patch(String id, Map<String, Object> partialData, String ... path) {
        Identifier defaultsIdentifier;
        Optional<EntityDataBuilder<EntityData>> newBuilder;
        String defaultId = Joiner.on('.').skipNulls().join(path);
        Map<String, Object> defaults = partialData;
        if (this.has(id, path) && (newBuilder = Optional.ofNullable(this.getBuilder(defaultsIdentifier = Identifier.from(id, path)).fillRequiredFieldsWithPlaceholders())).isPresent()) {
            try {
                ObjectMapper mapper = this.valueEncodingEntity.getMapper(this.valueEncodingEntity.getDefaultFormat());
                byte[] serialize = this.valueEncodingEntity.serialize(partialData);
                mapper.readerForUpdating(newBuilder.get()).readValue(serialize);
                byte[] payload = this.valueEncodingEntity.serialize((EntityData)newBuilder.get().build());
                defaults = this.valueEncodingMap.deserialize(defaultsIdentifier, payload, this.valueEncodingBuilder.getDefaultFormat(), false);
            }
            catch (Throwable e) {
                LogContext.error(LOGGER, e, "Deserialization error", new Object[0]);
            }
        }
        defaults = (Map<String, Object>)defaults.entrySet().stream().filter(entry -> !Objects.equals(entry.getValue(), "__DEFAULT__")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.put(defaultId, defaults, new String[0]).thenRun(() -> this.eventStore.replay(EventFilter.fromPath(Path.of("defaults", defaultId))));
        return CompletableFuture.completedFuture(defaults);
    }
}

